/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http;

import org.junit.Assert;
import org.junit.Test;
import org.mule.api.DefaultMuleException;
import org.mule.api.routing.RoutingException;
import org.mule.api.security.SecurityException;
import org.mule.api.security.UnauthorisedException;
import org.mule.config.ExceptionHelper;
import org.mule.config.i18n.MessageFactory;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class StatusCodeMappingsTestCase
extends AbstractMuleTestCase {
    @Test
    public void testErrorMappings() {
        String code = ExceptionHelper.getErrorMapping((String)"http", RoutingException.class);
        Assert.assertEquals((Object)"500", (Object)code);
        code = ExceptionHelper.getErrorMapping((String)"HTTP", SecurityException.class);
        Assert.assertEquals((Object)"403", (Object)code);
        code = ExceptionHelper.getErrorMapping((String)"http", UnauthorisedException.class);
        Assert.assertEquals((Object)"401", (Object)code);
        code = ExceptionHelper.getErrorMapping((String)"blah", DefaultMuleException.class);
        Assert.assertEquals((Object)String.valueOf(new DefaultMuleException(MessageFactory.createStaticMessage((String)"test")).getExceptionCode()), (Object)code);
    }

    @Test
    public void testHttpsErrorMappings() {
        String code = ExceptionHelper.getErrorMapping((String)"httpS", RoutingException.class);
        Assert.assertEquals((Object)"500", (Object)code);
        code = ExceptionHelper.getErrorMapping((String)"HTTPS", SecurityException.class);
        Assert.assertEquals((Object)"403", (Object)code);
        code = ExceptionHelper.getErrorMapping((String)"https", UnauthorisedException.class);
        Assert.assertEquals((Object)"401", (Object)code);
    }
}

