/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.functional;

import java.io.InputStream;
import org.junit.Assert;
import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.module.client.MuleClient;
import org.mule.module.xml.transformer.XsltTransformer;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.util.IOUtils;

public class HttpContentLengthPropagationTestCase
extends FunctionalTestCase {
    private static final String NAME_PAYLOAD = "test-xml-payload.xml";
    private static final String NAME_STYLESHEET = "stylesheet.xsl";

    protected String getConfigResources() {
        return "http-content-length-propagation-conf.xml";
    }

    @Test
    public void testContentLengthPropagation() throws Exception {
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(NAME_PAYLOAD);
        Assert.assertNotNull((String)"Payload test file not found.", (Object)is);
        byte[] fileContents = IOUtils.toByteArray((InputStream)is);
        MuleClient client = new MuleClient(muleContext);
        MuleMessage result = client.send(((InboundEndpoint)client.getMuleContext().getRegistry().lookupObject("httpEndpoint")).getAddress(), (MuleMessage)new DefaultMuleMessage((Object)fileContents, muleContext));
        XsltTransformer trans = new XsltTransformer();
        trans.setMuleContext(muleContext);
        trans.setXslFile(NAME_STYLESHEET);
        trans.initialise();
        byte[] locallyTransformedBytes = (byte[])trans.doTransform((Object)fileContents, "UTF-8");
        Assert.assertEquals((Object)new String(locallyTransformedBytes), (Object)result.getPayloadAsString());
    }
}

