/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.functional;

import java.io.BufferedReader;
import java.util.Arrays;
import java.util.Collection;
import java.util.StringTokenizer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.module.client.MuleClient;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.transport.http.functional.AbstractMockHttpServerTestCase;
import org.mule.transport.http.functional.MockHttpServer;
import org.mule.util.concurrent.Latch;

public class HttpOutboundTestCase
extends AbstractMockHttpServerTestCase {
    @ClassRule
    public static DynamicPort dynamicPort = new DynamicPort("port1");
    private Latch testLatch = new Latch();
    private String httpMethod;

    public HttpOutboundTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
        this.setDisposeContextPerClass(true);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "http-outbound-config-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "http-outbound-config-flow.xml"});
    }

    @Override
    protected MockHttpServer getHttpServer(CountDownLatch latch) {
        return new SimpleHttpServer(dynamicPort.getNumber(), latch, (CountDownLatch)this.testLatch);
    }

    @Test
    public void testOutboundDelete() throws Exception {
        this.sendHttpRequest("vm://doDelete", "DELETE");
    }

    @Test
    public void testOutboundGet() throws Exception {
        this.sendHttpRequest("vm://doGet", "GET");
    }

    @Test
    public void testOutboundHead() throws Exception {
        this.sendHttpRequest("vm://doHead", "HEAD");
    }

    @Test
    public void testOutboundOptions() throws Exception {
        this.sendHttpRequest("vm://doOptions", "OPTIONS");
    }

    @Test
    public void testOutboundPost() throws Exception {
        this.sendHttpRequest("vm://doPost", "POST");
    }

    @Test
    public void testOutboundPut() throws Exception {
        this.sendHttpRequest("vm://doPut", "PUT");
    }

    @Test
    public void testOutboundTrace() throws Exception {
        this.sendHttpRequest("vm://doTrace", "TRACE");
    }

    private void sendHttpRequest(String endpoint, String expectedHttpMethod) throws Exception {
        MuleClient client = new MuleClient(muleContext);
        client.dispatch(endpoint, (Object)"Test Message", null);
        Assert.assertTrue((boolean)this.testLatch.await(5000L, TimeUnit.MILLISECONDS));
        Assert.assertEquals((Object)expectedHttpMethod, (Object)this.httpMethod);
    }

    private class SimpleHttpServer
    extends MockHttpServer {
        public SimpleHttpServer(int listenPort, CountDownLatch startupLatch, CountDownLatch testCompleteLatch) {
            super(listenPort, startupLatch, testCompleteLatch);
        }

        @Override
        protected void readHttpRequest(BufferedReader reader) throws Exception {
            String line = reader.readLine();
            HttpOutboundTestCase.this.httpMethod = new StringTokenizer(line).nextToken();
        }
    }
}

