/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http;

import com.mockobjects.dynamic.Mock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.service.Service;
import org.mule.api.transport.MessageReceiver;
import org.mule.endpoint.EndpointURIEndpointBuilder;
import org.mule.service.ServiceCompositeMessageSource;
import org.mule.transport.AbstractMessageReceiverTestCase;
import org.mule.transport.http.HttpMessageReceiver;
import org.mule.transport.http.transformers.MuleMessageToHttpResponse;
import org.mule.util.CollectionUtils;

public class HttpMessageReceiverTestCase
extends AbstractMessageReceiverTestCase {
    private static final String CONTEXT_PATH = "/resources";
    private static final String CLIENT_PATH = "/resources/client";
    private static final String CLIENT_NAME_PATH = "/resources/client/name";
    private HttpMessageReceiver httpMessageReceiver;

    public MessageReceiver getMessageReceiver() throws Exception {
        Mock mockComponent = new Mock(Service.class);
        mockComponent.expect("getResponseRouter");
        mockComponent.expectAndReturn("getInboundRouter", (Object)new ServiceCompositeMessageSource());
        return new HttpMessageReceiver(this.endpoint.getConnector(), (FlowConstruct)((Service)mockComponent.proxy()), this.endpoint);
    }

    public InboundEndpoint getEndpoint() throws Exception {
        EndpointURIEndpointBuilder endpointBuilder = new EndpointURIEndpointBuilder("http://localhost:6789", muleContext);
        endpointBuilder.setResponseTransformers(CollectionUtils.singletonList((Object)new MuleMessageToHttpResponse()));
        this.endpoint = muleContext.getEndpointFactory().getInboundEndpoint((EndpointBuilder)endpointBuilder);
        return this.endpoint;
    }

    @Before
    public void setUp() throws Exception {
        this.httpMessageReceiver = (HttpMessageReceiver)this.getMessageReceiver();
    }

    @Test
    public void testProcessResourceRelativePath() {
        Assert.assertEquals((Object)"client", (Object)this.httpMessageReceiver.processRelativePath(CONTEXT_PATH, CLIENT_PATH));
    }

    @Test
    public void testProcessRelativePathSameLevel() {
        Assert.assertEquals((Object)"", (Object)this.httpMessageReceiver.processRelativePath(CONTEXT_PATH, CONTEXT_PATH));
    }

    @Test
    public void testProcessResourcePropertyRelativePath() {
        Assert.assertEquals((Object)"client/name", (Object)this.httpMessageReceiver.processRelativePath(CONTEXT_PATH, CLIENT_NAME_PATH));
    }
}

