/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.commons.httpclient.Header;
import org.junit.Assert;
import org.junit.Test;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleMessage;
import org.mule.api.transport.MuleMessageFactory;
import org.mule.transport.AbstractMuleMessageFactoryTestCase;
import org.mule.transport.http.HttpMuleMessageFactory;
import org.mule.transport.http.HttpMultipartMuleMessageFactory;
import org.mule.transport.http.HttpRequest;
import org.mule.transport.http.RequestLine;

public class HttpMultipartMuleMessageFactoryTestCase
extends AbstractMuleMessageFactoryTestCase {
    private static final String REQUEST_LINE = "POST /services/Echo HTTP/1.1";
    private static final String MULTIPART_BOUNDARY = "----------------------------299df9f9431b";
    private static final Header[] HEADERS = new Header[]{new Header("Content-Type", "multipart/form-data; boundary=----------------------------299df9f9431b")};
    private static final String MULTIPART_MESSAGE = "------------------------------299df9f9431b\r\nContent-Disposition: form-data; name=\"payload\"; filename=\"payload\"\r\nContent-Type: application/octet-stream\r\n\r\npart payload\r\n\r\n------------------------------299df9f9431b\r\nContent-Disposition: form-data; name=\"two\"; filename=\"two\"\r\nContent-Type: application/octet-stream\r\n\r\npart two\r\n\r\n------------------------------299df9f9431b--\r\n\r\n";

    protected MuleMessageFactory doCreateMuleMessageFactory() {
        return new HttpMultipartMuleMessageFactory(muleContext);
    }

    protected Object getValidTransportMessage() throws Exception {
        RequestLine requestLine = RequestLine.parseLine((String)REQUEST_LINE);
        HttpRequest request = new HttpRequest(requestLine, HEADERS, null, this.encoding);
        return request;
    }

    protected Object getUnsupportedTransportMessage() {
        return "this is not a valid transport message for HttpMuleMessageFactory";
    }

    @Test
    public void testValidPayload() throws Exception {
        HttpMuleMessageFactory factory = (HttpMuleMessageFactory)this.createMuleMessageFactory();
        factory.setExchangePattern(MessageExchangePattern.ONE_WAY);
        HttpRequest request = this.createMultiPartHttpRequest();
        MuleMessage message = factory.create((Object)request, this.encoding);
        Assert.assertNotNull((Object)message);
        Assert.assertTrue((boolean)(message.getPayload() instanceof InputStream));
    }

    private HttpRequest createMultiPartHttpRequest() throws Exception {
        RequestLine requestLine = RequestLine.parseLine((String)REQUEST_LINE);
        ByteArrayInputStream stream = new ByteArrayInputStream(MULTIPART_MESSAGE.getBytes());
        return new HttpRequest(requestLine, HEADERS, (InputStream)stream, this.encoding);
    }
}

