/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mule.api.MuleMessage;
import org.mule.api.expression.ExpressionManager;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.transport.http.CacheControlHeader;

@SmallTest
public class CacheControlTestCase
extends AbstractMuleTestCase {
    private static final String HEADER_DIRECTIVE = "#[header:directive]";
    private static final String HEADER_MAX_AGE = "#[header:maxAge]";
    private static final String HEADER_MUST_REVALIDATE = "#[header:mustRevalidate]";
    private static final String HEADER_NO_CACHE = "#[header:noCache]";
    private static final String HEADER_NO_STORE = "#[header:noStore]";
    private MuleMessage muleMessage;
    private ExpressionManager expressionManager;

    @Before
    public void setUp() {
        this.muleMessage = (MuleMessage)Mockito.mock(MuleMessage.class);
        this.expressionManager = (ExpressionManager)Mockito.mock(ExpressionManager.class);
    }

    @Test
    public void testCacheControlByDefault() {
        CacheControlHeader cacheControl = new CacheControlHeader();
        cacheControl.parse(this.muleMessage, this.expressionManager);
        Assert.assertEquals((Object)"", (Object)cacheControl.toString());
    }

    @Test
    public void testCacheControlFullConfig() {
        CacheControlHeader cacheControl = new CacheControlHeader();
        cacheControl.setDirective("public");
        cacheControl.setMaxAge("3600");
        cacheControl.setMustRevalidate("true");
        cacheControl.setNoCache("true");
        cacheControl.setNoStore("true");
        this.mockParse();
        cacheControl.parse(this.muleMessage, this.expressionManager);
        Assert.assertEquals((Object)"public,no-cache,no-store,must-revalidate,max-age=3600", (Object)cacheControl.toString());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCacheControlWrongDirective() {
        CacheControlHeader cacheControl = new CacheControlHeader();
        cacheControl.setDirective("anyDirective");
        this.mockParse();
        cacheControl.parse(this.muleMessage, this.expressionManager);
    }

    @Test
    public void testCacheControlWithExpressions() {
        CacheControlHeader cacheControl = new CacheControlHeader();
        cacheControl.setDirective(HEADER_DIRECTIVE);
        cacheControl.setMaxAge(HEADER_MAX_AGE);
        cacheControl.setMustRevalidate(HEADER_MUST_REVALIDATE);
        cacheControl.setNoCache(HEADER_NO_CACHE);
        cacheControl.setNoStore(HEADER_NO_STORE);
        Mockito.when((Object)this.expressionManager.parse(HEADER_DIRECTIVE, this.muleMessage)).thenReturn((Object)"public");
        Mockito.when((Object)this.expressionManager.parse(HEADER_MAX_AGE, this.muleMessage)).thenReturn((Object)"3600");
        Mockito.when((Object)this.expressionManager.parse(HEADER_MUST_REVALIDATE, this.muleMessage)).thenReturn((Object)"true");
        Mockito.when((Object)this.expressionManager.parse(HEADER_NO_CACHE, this.muleMessage)).thenReturn((Object)"true");
        Mockito.when((Object)this.expressionManager.parse(HEADER_NO_STORE, this.muleMessage)).thenReturn((Object)"true");
        cacheControl.parse(this.muleMessage, this.expressionManager);
        Assert.assertEquals((Object)"public,no-cache,no-store,must-revalidate,max-age=3600", (Object)cacheControl.toString());
    }

    private void mockParse() {
        Mockito.when((Object)this.expressionManager.parse(Matchers.anyString(), (MuleMessage)Mockito.any(MuleMessage.class))).thenAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                return invocation.getArguments()[0];
            }
        });
    }
}

