/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.httpclient.Cookie;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mule.api.MuleMessage;
import org.mule.api.expression.ExpressionManager;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.transport.http.CookieWrapper;

@SmallTest
public class CookieWrapperTestCase
extends AbstractMuleTestCase {
    private CookieWrapper cookieWrapper;
    private ExpressionManager mockExpressionManager;
    private MuleMessage mockMuleMessage;

    @Before
    public void setUp() {
        this.cookieWrapper = new CookieWrapper();
        this.mockExpressionManager = (ExpressionManager)Mockito.mock(ExpressionManager.class);
        this.mockMuleMessage = (MuleMessage)Mockito.mock(MuleMessage.class);
    }

    @Test
    public void testCookieWrapper() throws ParseException {
        this.cookieWrapper.setName("test");
        this.cookieWrapper.setValue("test");
        this.cookieWrapper.setDomain("localhost");
        this.cookieWrapper.setPath("/");
        this.cookieWrapper.setMaxAge("3600");
        this.cookieWrapper.setSecure("true");
        this.cookieWrapper.setVersion("1");
        this.mockParse();
        this.cookieWrapper.parse(this.mockMuleMessage, this.mockExpressionManager);
        Cookie cookie = this.cookieWrapper.createCookie();
        Assert.assertEquals((Object)"test", (Object)cookie.getName());
        Assert.assertEquals((Object)"test", (Object)cookie.getValue());
        Assert.assertEquals((Object)"localhost", (Object)cookie.getDomain());
        Assert.assertEquals((Object)"/", (Object)cookie.getPath());
        Assert.assertTrue((boolean)cookie.getSecure());
        Assert.assertEquals((long)1L, (long)cookie.getVersion());
    }

    @Test
    public void testCookieWrapperWithExpressions() throws ParseException {
        this.cookieWrapper.setName("#[name]");
        this.cookieWrapper.setValue("#[value]");
        this.cookieWrapper.setDomain("#[domain]");
        this.cookieWrapper.setPath("#[path]");
        this.cookieWrapper.setMaxAge("#[maxAge]");
        this.cookieWrapper.setSecure("#[secure]");
        this.cookieWrapper.setVersion("#[version]");
        Mockito.when((Object)this.mockExpressionManager.parse("#[name]", this.mockMuleMessage)).thenReturn((Object)"test");
        Mockito.when((Object)this.mockExpressionManager.parse("#[value]", this.mockMuleMessage)).thenReturn((Object)"test");
        Mockito.when((Object)this.mockExpressionManager.parse("#[domain]", this.mockMuleMessage)).thenReturn((Object)"localhost");
        Mockito.when((Object)this.mockExpressionManager.parse("#[path]", this.mockMuleMessage)).thenReturn((Object)"/");
        Mockito.when((Object)this.mockExpressionManager.parse("#[maxAge]", this.mockMuleMessage)).thenReturn((Object)"3600");
        Mockito.when((Object)this.mockExpressionManager.parse("#[secure]", this.mockMuleMessage)).thenReturn((Object)"true");
        Mockito.when((Object)this.mockExpressionManager.parse("#[version]", this.mockMuleMessage)).thenReturn((Object)"1");
        this.cookieWrapper.parse(this.mockMuleMessage, this.mockExpressionManager);
        Cookie cookie = this.cookieWrapper.createCookie();
        Assert.assertEquals((Object)"test", (Object)cookie.getName());
        Assert.assertEquals((Object)"test", (Object)cookie.getValue());
        Assert.assertEquals((Object)"localhost", (Object)cookie.getDomain());
        Assert.assertEquals((Object)"/", (Object)cookie.getPath());
        Assert.assertTrue((boolean)cookie.getSecure());
        Assert.assertEquals((long)1L, (long)cookie.getVersion());
    }

    @Test
    public void testCookieWrapperOnlyRequiredAttributes() throws ParseException {
        this.cookieWrapper.setName("test");
        this.cookieWrapper.setValue("test");
        this.mockParse();
        this.cookieWrapper.parse(this.mockMuleMessage, this.mockExpressionManager);
        Cookie cookie = this.cookieWrapper.createCookie();
        Assert.assertEquals((Object)"test=test", (Object)cookie.toString());
    }

    @Test
    public void testCookieWrapperStringExpiryDate() throws ParseException {
        this.cookieWrapper.setName("test");
        this.cookieWrapper.setValue("test");
        this.cookieWrapper.setExpiryDate((Object)"Sun, 15 Dec 2013 16:00:00 GMT");
        this.mockParse();
        this.cookieWrapper.parse(this.mockMuleMessage, this.mockExpressionManager);
        Cookie cookie = this.cookieWrapper.createCookie();
        Date expiryDate = cookie.getExpiryDate();
        SimpleDateFormat formatter = new SimpleDateFormat("EEE, dd MMM yyyy hh:mm:ss zzz", Locale.US);
        formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        Assert.assertNotNull((String)"Sun, 15 Dec 2013 16:00:00 GMT", (Object)formatter.format(expiryDate));
    }

    @Test
    public void testCookieWrapperExpiryDate() throws ParseException {
        Date now = new Date();
        this.cookieWrapper.setName("test");
        this.cookieWrapper.setValue("test");
        this.cookieWrapper.setExpiryDate((Object)now);
        this.mockParse();
        this.cookieWrapper.parse(this.mockMuleMessage, this.mockExpressionManager);
        Cookie cookie = this.cookieWrapper.createCookie();
        Date expiryDate = cookie.getExpiryDate();
        Assert.assertEquals((long)0L, (long)now.compareTo(expiryDate));
    }

    @Test
    public void testCookieWrapperExpiryDateExpression() throws ParseException {
        Date now = new Date();
        this.cookieWrapper.setName("test");
        this.cookieWrapper.setValue("test");
        this.cookieWrapper.setExpiryDate((Object)"#[expiryDate]");
        Mockito.when((Object)this.mockExpressionManager.isExpression("#[expiryDate]")).thenReturn((Object)true);
        Mockito.when((Object)this.mockExpressionManager.evaluate("#[expiryDate]", this.mockMuleMessage)).thenReturn((Object)now);
        this.mockParse();
        this.cookieWrapper.parse(this.mockMuleMessage, this.mockExpressionManager);
        Cookie cookie = this.cookieWrapper.createCookie();
        Date expiryDate = cookie.getExpiryDate();
        Assert.assertEquals((long)0L, (long)now.compareTo(expiryDate));
    }

    private void mockParse() {
        Mockito.when((Object)this.mockExpressionManager.parse(Matchers.anyString(), (MuleMessage)Mockito.any(MuleMessage.class))).thenAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                return (String)invocation.getArguments()[0];
            }
        });
    }
}

