/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.filters;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.module.client.MuleClient;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class HttpRequestWildcardFilterTestCase
extends AbstractServiceAndFlowTestCase {
    private static final String TEST_HTTP_MESSAGE = "Hello=World";
    private static final String TEST_BAD_MESSAGE = "xyz";
    @Rule
    public DynamicPort dynamicPort1 = new DynamicPort("port1");
    @Rule
    public DynamicPort dynamicPort2 = new DynamicPort("port2");

    public HttpRequestWildcardFilterTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "http-wildcard-filter-test-flow.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "http-wildcard-filter-test-service.xml"});
    }

    @Test
    public void testReference() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        MuleMessage result = client.send(((InboundEndpoint)client.getMuleContext().getRegistry().lookupObject("inReference")).getAddress(), (Object)TEST_HTTP_MESSAGE, null);
        Assert.assertEquals((Object)TEST_HTTP_MESSAGE, (Object)result.getPayloadAsString());
    }

    @Test
    public void testHttpPost() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        MuleMessage result = client.send(((InboundEndpoint)client.getMuleContext().getRegistry().lookupObject("inHttpIn")).getAddress(), (Object)TEST_HTTP_MESSAGE, null);
        Assert.assertEquals((Object)TEST_HTTP_MESSAGE, (Object)result.getPayloadAsString());
    }

    @Test
    public void testHttpGetNotFiltered() throws Exception {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("GET", "true");
        MuleClient client = new MuleClient(muleContext);
        MuleMessage result = client.send(((InboundEndpoint)client.getMuleContext().getRegistry().lookupObject("inHttpIn")).getAddress() + "/" + "mulerulez", (Object)TEST_HTTP_MESSAGE, props);
        Assert.assertEquals((Object)TEST_HTTP_MESSAGE, (Object)result.getPayloadAsString());
    }

    @Test
    public void testHttpGetFiltered() throws Exception {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("http.method", "GET");
        MuleClient client = new MuleClient(muleContext);
        MuleMessage result = client.send(((InboundEndpoint)client.getMuleContext().getRegistry().lookupObject("inHttpIn")).getAddress() + "/" + TEST_BAD_MESSAGE, (Object)"mule", props);
        int status = (Integer)result.getInboundProperty("http.status", (Object)0);
        Assert.assertEquals((long)406L, (long)status);
        Assert.assertNotNull((Object)result.getExceptionPayload());
    }
}

