/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.functional;

import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.functional.CounterCallback;
import org.mule.tck.functional.EventCallback;
import org.mule.tck.functional.FunctionalTestComponent;
import org.mule.tck.junit4.rule.DynamicPort;

public class PollingReceiversRestartTestCase
extends AbstractServiceAndFlowTestCase {
    private static final int WAIT_TIME = 3000;
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");

    public PollingReceiversRestartTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
        this.setStartContext(false);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "polling-receivers-restart-test-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "polling-receivers-restart-test-flow.xml"});
    }

    @Test
    public void testPollingReceiversRestart() throws Exception {
        muleContext.start();
        Object ftc = this.getComponent("Test");
        Assert.assertTrue((String)"FunctionalTestComponent expected", (boolean)(ftc instanceof FunctionalTestComponent));
        AtomicInteger pollCounter = new AtomicInteger(0);
        ((FunctionalTestComponent)ftc).setEventCallback((EventCallback)new CounterCallback(pollCounter));
        Thread.sleep(3000L);
        muleContext.stop();
        Assert.assertTrue((String)"No polls performed", (pollCounter.get() > 0 ? 1 : 0) != 0);
        muleContext.start();
        pollCounter.set(0);
        ((FunctionalTestComponent)ftc).setEventCallback((EventCallback)new CounterCallback(pollCounter));
        Thread.sleep(3000L);
        muleContext.dispose();
        Assert.assertTrue((String)"No polls performed", (pollCounter.get() > 0 ? 1 : 0) != 0);
    }
}

