/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http;

import org.junit.Assert;
import org.junit.Test;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.routing.filter.Filter;
import org.mule.transport.http.AbstractNamespaceHandlerTestCase;
import org.mule.transport.http.HttpConnector;
import org.mule.transport.http.HttpPollingConnector;
import org.mule.transport.http.filters.HttpRequestWildcardFilter;
import org.mule.transport.http.transformers.HttpClientMethodResponseToObject;
import org.mule.transport.http.transformers.HttpResponseToString;
import org.mule.transport.http.transformers.MuleMessageToHttpResponse;
import org.mule.transport.http.transformers.ObjectToHttpClientMethodRequest;

public class HttpNamespaceHandlerTestCase
extends AbstractNamespaceHandlerTestCase {
    public HttpNamespaceHandlerTestCase() {
        super("http");
    }

    @Test
    public void testConnectorProperties() {
        HttpConnector connector = (HttpConnector)muleContext.getRegistry().lookupConnector("httpConnector");
        this.testBasicProperties(connector);
    }

    @Test
    public void testPollingProperties() {
        HttpPollingConnector connector = (HttpPollingConnector)muleContext.getRegistry().lookupConnector("polling");
        Assert.assertNotNull((Object)connector);
        Assert.assertEquals((long)3456L, (long)connector.getPollingFrequency());
        Assert.assertFalse((boolean)connector.isCheckEtag());
        Assert.assertFalse((boolean)connector.isDiscardEmptyContent());
    }

    @Test
    public void testTransformersOnEndpoints() throws Exception {
        Object transformer1 = this.lookupInboundEndpoint("ep1").getTransformers().get(0);
        Assert.assertNotNull(transformer1);
        Assert.assertEquals(HttpClientMethodResponseToObject.class, transformer1.getClass());
        Object transformer2 = this.lookupInboundEndpoint("ep2").getTransformers().get(0);
        Assert.assertNotNull(transformer2);
        Assert.assertEquals(HttpResponseToString.class, transformer2.getClass());
        Object transformer3 = this.lookupInboundEndpoint("ep3").getTransformers().get(0);
        Assert.assertNotNull(transformer3);
        Assert.assertEquals(MuleMessageToHttpResponse.class, transformer3.getClass());
        Object transformer4 = this.lookupInboundEndpoint("ep4").getTransformers().get(0);
        Assert.assertNotNull(transformer4);
        Assert.assertEquals(ObjectToHttpClientMethodRequest.class, transformer4.getClass());
    }

    @Test
    public void testFiltersOnEndpoints() throws Exception {
        Filter filter = this.lookupInboundEndpoint("ep5").getFilter();
        Assert.assertNotNull((Object)filter);
        Assert.assertEquals(HttpRequestWildcardFilter.class, filter.getClass());
        HttpRequestWildcardFilter requestWildcardFilter = (HttpRequestWildcardFilter)filter;
        Assert.assertEquals((Object)"foo*", (Object)requestWildcardFilter.getPattern());
    }

    private InboundEndpoint lookupInboundEndpoint(String endpointName) throws Exception {
        InboundEndpoint endpoint = muleContext.getEndpointFactory().getInboundEndpoint(endpointName);
        Assert.assertNotNull((Object)endpoint);
        return endpoint;
    }
}

