/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.functional;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.module.client.MuleClient;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class HttpDynamicFunctionalTestCase
extends AbstractServiceAndFlowTestCase {
    protected static String TEST_REQUEST = "Test Http Request";
    @Rule
    public DynamicPort dynamicPort1 = new DynamicPort("port1");
    @Rule
    public DynamicPort dynamicPort2 = new DynamicPort("port2");

    public HttpDynamicFunctionalTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "http-dynamic-functional-test-flow.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "http-dynamic-functional-test-service.xml"});
    }

    @Test
    public void testSend() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("port", this.dynamicPort1.getNumber());
        props.put("path", "foo");
        MuleMessage result = client.send("clientEndpoint", (Object)TEST_REQUEST, props);
        Assert.assertEquals((Object)(TEST_REQUEST + " Received 1"), (Object)result.getPayloadAsString());
        props.put("port", this.dynamicPort2.getNumber());
        result = client.send("clientEndpoint", (Object)TEST_REQUEST, props);
        Assert.assertEquals((Object)(TEST_REQUEST + " Received 2"), (Object)result.getPayloadAsString());
    }
}

