/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.functional;

import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.module.client.MuleClient;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class HttpKeepAliveFunctionalTestCase
extends AbstractServiceAndFlowTestCase {
    private HttpClient http10Client;
    private HttpClient http11Client;
    private MuleClient client = null;
    @Rule
    public DynamicPort dynamicPort1 = new DynamicPort("port1");
    @Rule
    public DynamicPort dynamicPort2 = new DynamicPort("port2");

    public HttpKeepAliveFunctionalTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "http-keep-alive-config-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "http-keep-alive-config-flow.xml"});
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.http10Client = this.setupHttpClient(HttpVersion.HTTP_1_0);
        this.http11Client = this.setupHttpClient(HttpVersion.HTTP_1_1);
        this.client = new MuleClient(muleContext);
    }

    private HttpClient setupHttpClient(HttpVersion version) {
        HttpClientParams params = new HttpClientParams();
        params.setVersion(version);
        return new HttpClient(params);
    }

    @Test
    public void testHttp10WithoutConnectionHeader() throws Exception {
        GetMethod request = new GetMethod(((InboundEndpoint)this.client.getMuleContext().getRegistry().lookupObject("inWithoutEndpointOverride")).getAddress());
        request.removeRequestHeader("Connection");
        this.runHttp10MethodAndAssertConnectionHeader((HttpMethod)request, "close");
    }

    @Test
    public void testHttp10WithCloseConnectionHeader() throws Exception {
        GetMethod request = new GetMethod(((InboundEndpoint)this.client.getMuleContext().getRegistry().lookupObject("inWithoutEndpointOverride")).getAddress());
        request.setRequestHeader("Connection", "close");
        this.runHttp10MethodAndAssertConnectionHeader((HttpMethod)request, "close");
    }

    @Test
    public void testHttp10KeepAlive() throws Exception {
        this.doTestKeepAlive(((InboundEndpoint)this.client.getMuleContext().getRegistry().lookupObject("inWithoutEndpointOverride")).getAddress());
    }

    @Test
    public void testHttp10KeepAliveWitEpOverride() throws Exception {
        this.doTestKeepAlive(((InboundEndpoint)this.client.getMuleContext().getRegistry().lookupObject("inWithoutEndpointOverride")).getAddress());
    }

    private void doTestKeepAlive(String url) throws Exception {
        GetMethod request = new GetMethod(url);
        request.addRequestHeader("Connection", "Keep-Alive");
        this.runHttp10MethodAndAssertConnectionHeader((HttpMethod)request, "Keep-Alive");
        request.setRequestHeader("Connection", "close");
        this.runHttp10MethodAndAssertConnectionHeader((HttpMethod)request, "close");
    }

    private void runHttp10MethodAndAssertConnectionHeader(HttpMethod request, String expectedConnectionHeaderValue) throws Exception {
        int status = this.http10Client.executeMethod(request);
        Assert.assertEquals((long)200L, (long)status);
        String connectionHeader = request.getResponseHeader("Connection").getValue();
        Assert.assertNotNull((Object)connectionHeader);
        Assert.assertEquals((Object)expectedConnectionHeaderValue, (Object)connectionHeader);
    }

    @Test
    public void testHttp11KeepAlive() throws Exception {
        this.doTestHttp11KeepAlive(((InboundEndpoint)this.client.getMuleContext().getRegistry().lookupObject("inWithoutEndpointOverride")).getAddress());
    }

    @Test
    public void testHttp11KeepAliveWithEpOverride() throws Exception {
        this.doTestHttp11KeepAlive(((InboundEndpoint)this.client.getMuleContext().getRegistry().lookupObject("inWithoutEndpointOverride")).getAddress());
    }

    public void doTestHttp11KeepAlive(String url) throws Exception {
        GetMethod request = new GetMethod(url);
        this.runHttp11MethodAndAssert((HttpMethod)request);
        request = new GetMethod(url);
        request.setRequestHeader("Connection", "close");
        this.runHttp11MethodAndAssert((HttpMethod)request);
        Header connectHeader = request.getResponseHeader("Connection");
        Assert.assertNotNull((Object)connectHeader);
        Assert.assertEquals((Object)"close", (Object)connectHeader.getValue());
    }

    private void runHttp11MethodAndAssert(HttpMethod request) throws Exception {
        int status = this.http11Client.executeMethod(request);
        Assert.assertEquals((long)200L, (long)status);
        Assert.assertEquals((Object)"/http-in", (Object)request.getResponseBodyAsString());
    }
}

