/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http;

import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleContext;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.service.Service;
import org.mule.api.transport.Connector;
import org.mule.tck.testmodels.fruit.Orange;
import org.mule.transport.AbstractConnectorTestCase;
import org.mule.transport.http.HttpsConnector;

public class HttpsConnectorTestCase
extends AbstractConnectorTestCase {
    public Connector createConnector() throws Exception {
        return HttpsConnectorTestCase.createConnector(muleContext, false);
    }

    public static HttpsConnector createConnector(MuleContext context, boolean initialised) throws IOException, InitialisationException {
        HttpsConnector cnn = new HttpsConnector(muleContext);
        cnn.setName("HttpsConnector");
        cnn.setKeyStore("serverKeystore");
        cnn.setClientKeyStore("clientKeystore");
        cnn.setClientKeyStorePassword("mulepassword");
        cnn.setKeyPassword("mulepassword");
        cnn.setKeyStorePassword("mulepassword");
        cnn.setTrustStore("trustStore");
        cnn.setTrustStorePassword("mulepassword");
        cnn.getDispatcherThreadingProfile().setDoThreading(false);
        if (initialised) {
            cnn.initialise();
        }
        return cnn;
    }

    public String getTestEndpointURI() {
        return "https://localhost:60127";
    }

    public Object getValidMessage() throws Exception {
        return "Hello".getBytes();
    }

    @Test
    public void testValidListener() throws Exception {
        Service service = HttpsConnectorTestCase.getTestService((String)"orange", Orange.class);
        InboundEndpoint endpoint = muleContext.getEndpointFactory().getInboundEndpoint(this.getTestEndpointURI());
        this.getConnector().registerListener(endpoint, (MessageProcessor)this.getSensingNullMessageProcessor(), (FlowConstruct)service);
    }

    @Test
    public void testProperties() throws Exception {
        HttpsConnector c = (HttpsConnector)this.getConnector();
        c.setSendBufferSize(1024);
        Assert.assertEquals((long)1024L, (long)c.getSendBufferSize());
        c.setSendBufferSize(0);
        Assert.assertEquals((long)-1L, (long)c.getSendBufferSize());
    }
}

