/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.components;

import java.io.BufferedReader;
import java.util.Arrays;
import java.util.Collection;
import java.util.StringTokenizer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.module.client.MuleClient;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.transport.http.functional.AbstractMockHttpServerTestCase;
import org.mule.transport.http.functional.MockHttpServer;

public class RestServiceComponentDeleteTestCase
extends AbstractMockHttpServerTestCase {
    private CountDownLatch serverRequestCompleteLatch = new CountDownLatch(1);
    private boolean deleteRequestFound = false;
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");

    public RestServiceComponentDeleteTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "rest-service-component-delete-test-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "rest-service-component-delete-test-flow.xml"});
    }

    @Override
    protected MockHttpServer getHttpServer(CountDownLatch serverStartLatch) {
        return new SimpleHttpServer(this.dynamicPort.getNumber(), serverStartLatch, this.serverRequestCompleteLatch);
    }

    @Test
    public void testRestServiceComponentDelete() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        client.send("vm://fromTest", (Object)"Test Message", null);
        Assert.assertTrue((boolean)this.serverRequestCompleteLatch.await(5000L, TimeUnit.MILLISECONDS));
        Assert.assertTrue((boolean)this.deleteRequestFound);
    }

    private class SimpleHttpServer
    extends MockHttpServer {
        public SimpleHttpServer(int listenPort, CountDownLatch startupLatch, CountDownLatch testCompleteLatch) {
            super(listenPort, startupLatch, testCompleteLatch);
        }

        @Override
        protected void readHttpRequest(BufferedReader reader) throws Exception {
            String requestLine = reader.readLine();
            String httpMethod = new StringTokenizer(requestLine).nextToken();
            RestServiceComponentDeleteTestCase.this.deleteRequestFound = httpMethod.equals("DELETE");
        }
    }
}

