/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.functional;

import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEventContext;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.functional.EventCallback;
import org.mule.tck.functional.FunctionalTestComponent;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.util.IOUtils;
import org.mule.util.StringDataSource;

public class HttpAttachmentsFunctionalTestCase
extends AbstractServiceAndFlowTestCase {
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");

    public HttpAttachmentsFunctionalTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "http-attachments-functional-test-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "http-attachments-functional-test-flow.xml"});
    }

    @Test
    public void testSendAttachment() throws Exception {
        FunctionalTestComponent ftc = this.getFunctionalTestComponent("testComponent");
        Assert.assertNotNull((Object)ftc);
        ftc.setEventCallback(new EventCallback(){

            public void eventReceived(MuleEventContext context, Object component) throws Exception {
                Assert.assertEquals((Object)"application/octet-stream; charset=ISO-8859-1", (Object)context.getMessage().getInboundProperty("Content-Type"));
                Assert.assertEquals((String)"We should have an attachment", (long)1L, (long)context.getMessage().getInboundAttachmentNames().size());
                DataHandler dh = context.getMessage().getInboundAttachment("attach1");
                Assert.assertNotNull((String)"DataHandler with name 'attach1' should not be null", (Object)dh);
                Assert.assertEquals((String)"We should have an attachment with foo", (Object)"foo", (Object)IOUtils.toString((InputStream)dh.getInputStream()));
                Assert.assertEquals((Object)"text/plain; charset=ISO-8859-1", (Object)dh.getContentType());
            }
        });
        LocalMuleClient client = muleContext.getClient();
        DefaultMuleMessage msg = new DefaultMuleMessage((Object)"test", muleContext);
        msg.addOutboundAttachment("attach1", new DataHandler((DataSource)new StringDataSource("foo", "attach1")));
        MuleMessage result = client.send("endpoint1", (MuleMessage)msg);
        Assert.assertEquals((String)"We should have no attachments coming back", (long)0L, (long)result.getInboundAttachmentNames().size());
    }
}

