/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.functional;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.transport.http.HttpConstants;
import org.mule.transport.http.functional.HttpFunctionalTestCase;

public class HttpOutboundHeadersPropagationTestCase
extends HttpFunctionalTestCase {
    protected static String TEST_MESSAGE = "Test Http Request (R\u00ef\u00bf\u00bddgr\u00ef\u00bf\u00bdd), 57 = \u06f7\u06f5 in Arabic";
    private static String TEST_JAPANESE_MESSAGE = "\u3042";

    public HttpOutboundHeadersPropagationTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
        this.setDisposeContextPerClass(true);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList(new Object[][]{{AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "http-outbound-headers-propagation-flow.xml"}});
    }

    @Override
    public void testSend() throws Exception {
    }

    @Test
    public void outboundHttpContentTypeTest() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        HashMap<String, String> msgProps = new HashMap<String, String>();
        msgProps.put("custom-header", "value-custom-header");
        client.dispatch("vm://in", (Object)"HelloWorld!", msgProps);
        MuleMessage reply = client.request("vm://out", 120000L);
        Map headers = (Map)reply.getPayload();
        for (String header : HttpConstants.REQUEST_HEADER_NAMES.values()) {
            if ("Expect".equals(header)) continue;
            if ("Cookie".equals(header)) {
                Assert.assertNotNull((String)("Request header <" + header + "> mshould be defined."), headers.get("cookies"));
                continue;
            }
            Assert.assertNotNull((String)("Request header <" + header + "> should be defined."), headers.get(header));
        }
        for (String header : HttpConstants.GENERAL_AND_ENTITY_HEADER_NAMES.values()) {
            Assert.assertNotNull((String)("General or Entity header <" + header + "> should be defined."), headers.get(header));
        }
        for (String header : HttpConstants.RESPONSE_HEADER_NAMES.values()) {
            Assert.assertNull((String)("Response header <" + header + "> should not be defined."), headers.get(header));
        }
        Assert.assertNotNull((Object)reply);
    }
}

