/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.transformers;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import org.apache.commons.httpclient.ChunkedOutputStream;
import org.apache.commons.httpclient.Header;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.mule.RequestContext;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transport.OutputHandler;
import org.mule.transformer.AbstractTransformer;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.transport.http.HttpResponse;
import org.mule.transport.http.ResponseWriter;

public class HttpResponseToString
extends AbstractTransformer {
    public HttpResponseToString() {
        this.registerSourceType(DataTypeFactory.create(HttpResponse.class));
        this.setReturnDataType(DataTypeFactory.STRING);
    }

    protected Object doTransform(Object src, String encoding) throws TransformerException {
        try {
            ByteArrayOutputStream bos;
            HttpResponse response = (HttpResponse)src;
            ByteArrayOutputStream outstream = bos = new ByteArrayOutputStream(8192);
            ResponseWriter writer = new ResponseWriter((OutputStream)outstream, encoding);
            writer.println(response.getStatusLine());
            Iterator item = response.getHeaderIterator();
            while (item.hasNext()) {
                Header header = (Header)item.next();
                writer.print(header.toExternalForm());
            }
            writer.println();
            writer.flush();
            if (response.hasBody()) {
                OutputHandler handler = response.getBody();
                Header transferenc = response.getFirstHeader("Transfer-Encoding");
                if (transferenc != null) {
                    response.removeHeaders("Content-Length");
                    if (transferenc.getValue().indexOf("chunked") != -1) {
                        outstream = new ChunkedOutputStream((OutputStream)outstream);
                    }
                }
                handler.write(RequestContext.getEvent(), (OutputStream)outstream);
                if (outstream instanceof ChunkedOutputStream) {
                    ((ChunkedOutputStream)outstream).finish();
                }
            }
            outstream.flush();
            bos.flush();
            byte[] result = bos.toByteArray();
            outstream.close();
            writer.close();
            bos.close();
            String output = null;
            try {
                output = new String(result, encoding);
            }
            catch (UnsupportedEncodingException uee) {
                output = new String(result);
            }
            return output;
        }
        catch (IOException e) {
            throw new TransformerException((Transformer)this, (Throwable)e);
        }
    }
}

