/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Answers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleContext;
import org.mule.api.routing.RoutingException;
import org.mule.api.security.SecurityException;
import org.mule.api.security.UnauthorisedException;
import org.mule.config.ExceptionHelper;
import org.mule.config.i18n.MessageFactory;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class StatusCodeMappingsTestCase
extends AbstractMuleTestCase {
    MuleContext mockMuleContext = (MuleContext)Mockito.mock(MuleContext.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());

    @Before
    public void setUp() {
        Mockito.when((Object)this.mockMuleContext.getConfiguration().getId()).thenReturn((Object)"1");
        Mockito.when((Object)this.mockMuleContext.getExecutionClassLoader()).thenReturn((Object)((Object)((Object)this)).getClass().getClassLoader());
    }

    @Test
    public void testErrorMappings() {
        String code = ExceptionHelper.getErrorMapping((String)"http", RoutingException.class, (MuleContext)this.mockMuleContext);
        Assert.assertEquals((Object)"500", (Object)code);
        code = ExceptionHelper.getErrorMapping((String)"HTTP", SecurityException.class, (MuleContext)this.mockMuleContext);
        Assert.assertEquals((Object)"403", (Object)code);
        code = ExceptionHelper.getErrorMapping((String)"http", UnauthorisedException.class, (MuleContext)this.mockMuleContext);
        Assert.assertEquals((Object)"401", (Object)code);
        code = ExceptionHelper.getErrorMapping((String)"blah", DefaultMuleException.class, (MuleContext)this.mockMuleContext);
        Assert.assertEquals((Object)String.valueOf(new DefaultMuleException(MessageFactory.createStaticMessage((String)"test")).getExceptionCode()), (Object)code);
    }

    @Test
    public void testHttpsErrorMappings() {
        String code = ExceptionHelper.getErrorMapping((String)"httpS", RoutingException.class, (MuleContext)this.mockMuleContext);
        Assert.assertEquals((Object)"500", (Object)code);
        code = ExceptionHelper.getErrorMapping((String)"HTTPS", SecurityException.class, (MuleContext)this.mockMuleContext);
        Assert.assertEquals((Object)"403", (Object)code);
        code = ExceptionHelper.getErrorMapping((String)"https", UnauthorisedException.class, (MuleContext)this.mockMuleContext);
        Assert.assertEquals((Object)"401", (Object)code);
    }
}

