/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.functional;

import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.transport.http.functional.HttpFunctionalTestCase;

public class HttpEncodingFunctionalTestCase
extends HttpFunctionalTestCase {
    protected static String TEST_MESSAGE = "Test Http Request (R\u00ef\u00bf\u00bddgr\u00ef\u00bf\u00bdd), 57 = \u06f7\u06f5 in Arabic";
    private static String TEST_JAPANESE_MESSAGE = "\u3042";

    public HttpEncodingFunctionalTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
        this.setDisposeContextPerClass(true);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "http-encoding-test-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "http-encoding-test-flow.xml"});
    }

    @Override
    public void testSend() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        HashMap<String, String> messageProperties = new HashMap<String, String>();
        messageProperties.put("Content-Type", this.getSendEncoding());
        MuleMessage reply = client.send("clientEndpoint", (Object)TEST_MESSAGE, messageProperties);
        Assert.assertNotNull((Object)reply);
        Assert.assertEquals((Object)"200", (Object)reply.getInboundProperty("http.status"));
        Assert.assertEquals((Object)"text/baz;charset=UTF-16BE", (Object)reply.getInboundProperty("Content-Type"));
        Assert.assertEquals((Object)"UTF-16BE", (Object)reply.getEncoding());
        Assert.assertEquals((Object)(TEST_MESSAGE + " Received"), (Object)reply.getPayloadAsString());
    }

    @Test
    public void testPostEncodingUsAscii() throws Exception {
        this.runPostEncodingTest("US-ASCII", "A");
    }

    @Test
    public void testPostEncodingUtf8() throws Exception {
        this.runPostEncodingTest("UTF-8", "A");
        this.runPostEncodingTest("UTF-8", TEST_JAPANESE_MESSAGE);
    }

    @Test
    @Ignore(value="MULE-3690 make me run green")
    public void testPostEncodingShiftJs() throws Exception {
        this.runPostEncodingTest("Shift_JIS", TEST_JAPANESE_MESSAGE);
    }

    @Test
    @Ignore(value="MULE-3690 make me run green")
    public void testPostEncodingWindows31J() throws Exception {
        this.runPostEncodingTest("Windows-31J", TEST_JAPANESE_MESSAGE);
    }

    @Test
    @Ignore(value="MULE-3690 make me run green")
    public void testPostEncodingEucJp() throws Exception {
        this.runPostEncodingTest("EUC-JP", TEST_JAPANESE_MESSAGE);
    }

    @Test
    @Ignore(value="MULE-3690 make me run green")
    public void testGetEncodingUsAscii() throws Exception {
        this.runGetEncodingTest("US-ASCII", "A");
    }

    @Test
    @Ignore(value="MULE-3690 make me run green")
    public void testGetEncodingUtf8() throws Exception {
        this.runGetEncodingTest("UTF-8", "A");
        this.runGetEncodingTest("UTF-8", TEST_JAPANESE_MESSAGE);
    }

    @Test
    @Ignore(value="MULE-3690 make me run green")
    public void testGetEncodingShiftJs() throws Exception {
        this.runGetEncodingTest("Shift_JIS", TEST_JAPANESE_MESSAGE);
    }

    @Test
    @Ignore(value="MULE-3690 make me run green")
    public void testGetEncodingWindows31J() throws Exception {
        this.runGetEncodingTest("Windows-31J", TEST_JAPANESE_MESSAGE);
    }

    @Test
    @Ignore(value="MULE-3690 make me run green")
    public void testGetEncodingEucJp() throws Exception {
        this.runGetEncodingTest("EUC-JP", TEST_JAPANESE_MESSAGE);
    }

    private void runPostEncodingTest(String encoding, String payload) throws Exception {
        MuleMessage reply = this.runEncodingTest(encoding, payload, "POST");
        Assert.assertEquals((Object)(payload + " Received"), (Object)reply.getPayloadAsString());
    }

    private void runGetEncodingTest(String encoding, String payload) throws Exception {
        MuleMessage reply = this.runEncodingTest(encoding, payload, "GET");
        String expectedReplyMessage = "/" + encoding + "?body=" + URLEncoder.encode(payload, encoding);
        Assert.assertEquals((Object)(expectedReplyMessage + " Received"), (Object)reply.getPayloadAsString());
    }

    private MuleMessage runEncodingTest(String encoding, String payload, String httpMethod) throws Exception {
        Map<String, Object> messageProperties = this.createMessageProperties(encoding, httpMethod);
        LocalMuleClient client = muleContext.getClient();
        String endpointUri = "clientEndpoint." + encoding;
        MuleMessage reply = client.send(endpointUri, (Object)payload, messageProperties);
        Assert.assertNotNull((Object)reply);
        Assert.assertEquals((Object)"200", (Object)reply.getInboundProperty("http.status"));
        Object contentTypeHeader = reply.getInboundProperty("Content-Type");
        Assert.assertEquals((Object)("text/plain;charset=" + encoding), (Object)contentTypeHeader);
        Assert.assertEquals((Object)encoding, (Object)reply.getEncoding());
        return reply;
    }

    private Map<String, Object> createMessageProperties(String encoding, String httpMethod) {
        HashMap<String, Object> messageProperties = new HashMap<String, Object>();
        String contentType = "text/plain;charset=" + encoding;
        messageProperties.put("Content-Type", contentType);
        messageProperties.put("http.method", httpMethod);
        return messageProperties;
    }

    protected String getSendEncoding() {
        return "text/plain;charset=UTF-8";
    }
}

