/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.functional;

import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.OptionsMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.TraceMethod;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.transport.http.PatchMethod;

public class HttpMethodTestCase
extends AbstractServiceAndFlowTestCase {
    @ClassRule
    public static DynamicPort dynamicPort = new DynamicPort("port1");
    private HttpClient client;

    public HttpMethodTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
        this.setDisposeContextPerClass(true);
        this.client = new HttpClient();
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "http-method-test-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "http-method-test-flow.xml"});
    }

    @Test
    public void testHead() throws Exception {
        HeadMethod method = new HeadMethod(this.getHttpEndpointAddress());
        int statusCode = this.client.executeMethod((HttpMethod)method);
        Assert.assertEquals((long)200L, (long)statusCode);
    }

    @Test
    public void testOptions() throws Exception {
        OptionsMethod method = new OptionsMethod(this.getHttpEndpointAddress());
        int statusCode = this.client.executeMethod((HttpMethod)method);
        Assert.assertEquals((long)200L, (long)statusCode);
    }

    @Test
    public void testPut() throws Exception {
        PutMethod method = new PutMethod(this.getHttpEndpointAddress());
        int statusCode = this.client.executeMethod((HttpMethod)method);
        Assert.assertEquals((long)200L, (long)statusCode);
    }

    @Test
    public void testDelete() throws Exception {
        DeleteMethod method = new DeleteMethod(this.getHttpEndpointAddress());
        int statusCode = this.client.executeMethod((HttpMethod)method);
        Assert.assertEquals((long)200L, (long)statusCode);
    }

    @Test
    public void testTrace() throws Exception {
        TraceMethod method = new TraceMethod(this.getHttpEndpointAddress());
        int statusCode = this.client.executeMethod((HttpMethod)method);
        Assert.assertEquals((long)200L, (long)statusCode);
    }

    @Test
    public void testConnect() throws Exception {
        CustomHttpMethod method = new CustomHttpMethod("CONNECT", this.getHttpEndpointAddress());
        int statusCode = this.client.executeMethod((HttpMethod)method);
        Assert.assertEquals((long)200L, (long)statusCode);
    }

    @Test
    public void testPatch() throws Exception {
        PatchMethod method = new PatchMethod(this.getHttpEndpointAddress());
        int statusCode = this.client.executeMethod((HttpMethod)method);
        Assert.assertEquals((long)200L, (long)statusCode);
    }

    @Test
    public void testFoo() throws Exception {
        CustomHttpMethod method = new CustomHttpMethod("FOO", this.getHttpEndpointAddress());
        int statusCode = this.client.executeMethod((HttpMethod)method);
        Assert.assertEquals((long)400L, (long)statusCode);
    }

    private String getHttpEndpointAddress() {
        InboundEndpoint httpEndpoint = (InboundEndpoint)muleContext.getRegistry().lookupObject("inHttpIn");
        return httpEndpoint.getAddress();
    }

    private static class CustomHttpMethod
    extends HttpMethodBase {
        private final String method;

        public CustomHttpMethod(String method, String url) {
            super(url);
            this.method = method;
        }

        public String getName() {
            return this.method;
        }
    }
}

