/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import javax.resource.spi.work.Work;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.mule.api.exception.SystemExceptionHandler;
import org.mule.api.transport.NoReceiverForEndpointException;
import org.mule.message.processing.MessageProcessContext;
import org.mule.tck.size.SmallTest;
import org.mule.transport.http.HttpConnector;
import org.mule.transport.http.HttpMessageReceiver;
import org.mule.transport.http.HttpRequestDispatcherWork;
import org.mule.transport.http.HttpServerConnection;
import org.mule.transport.http.RequestLine;

@RunWith(value=MockitoJUnitRunner.class)
@SmallTest
public class HttpRequestDispatcherWorkTestCase {
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private HttpConnector mockHttpConnector;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private Socket mockSocket;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private InetSocketAddress mockInetSocketAddress;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private HttpMessageReceiver mockHttpMessageReceiver;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private Work mockWork;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private MessageProcessContext mockMessageContext;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    NoReceiverForEndpointException mockNoReceiverForEndpointException;

    @Test(expected=IllegalArgumentException.class)
    public void createHttpRequestDispatcherWorkWithNullHttpConnector() {
        new HttpRequestDispatcherWork(null, this.mockSocket);
    }

    @Test(expected=IllegalArgumentException.class)
    public void createHttpRequestDispatcherWorkWithNullServerSocket() {
        new HttpRequestDispatcherWork(this.mockHttpConnector, null);
    }

    @Test
    public void onExceptionCallSystemExceptionHandler() throws Exception {
        HttpRequestDispatcherWork httpRequestDispatcherWork = new HttpRequestDispatcherWork(this.mockHttpConnector, this.mockSocket);
        this.setUpSocketMessage();
        Mockito.when((Object)this.mockHttpConnector.lookupReceiver((Socket)Matchers.any(Socket.class), (RequestLine)Matchers.any(RequestLine.class))).thenThrow(new Class[]{Exception.class});
        httpRequestDispatcherWork.run();
        ((SystemExceptionHandler)Mockito.verify((Object)this.mockHttpConnector.getMuleContext().getExceptionListener(), (VerificationMode)Mockito.times((int)1))).handleException((Exception)Matchers.any(Exception.class));
    }

    @Test
    public void requestPathWithNoReceiver() throws Exception {
        HttpRequestDispatcherWork httpRequestDispatcherWork = new HttpRequestDispatcherWork(this.mockHttpConnector, this.mockSocket);
        this.setUpSocketMessage();
        Mockito.when((Object)this.mockSocket.getLocalSocketAddress()).thenReturn((Object)this.mockInetSocketAddress);
        Mockito.when((Object)this.mockHttpConnector.lookupReceiver((Socket)Matchers.any(Socket.class), (RequestLine)Matchers.any(RequestLine.class))).thenThrow(new Throwable[]{this.mockNoReceiverForEndpointException});
        ByteArrayOutputStream socketOutput = new ByteArrayOutputStream();
        Mockito.when((Object)this.mockSocket.getOutputStream()).thenReturn((Object)socketOutput);
        httpRequestDispatcherWork.run();
        String response = new String(socketOutput.toByteArray());
        Assert.assertThat((Object)response.startsWith("HTTP/1.0 404 Not Found"), (Matcher)Is.is((Object)true));
    }

    @Test
    public void onValidUriProcessRequest() throws Exception {
        HttpRequestDispatcherWork httpRequestDispatcherWork = new HttpRequestDispatcherWork(this.mockHttpConnector, this.mockSocket);
        Mockito.when((Object)this.mockHttpConnector.lookupReceiver((Socket)Matchers.isA(Socket.class), (RequestLine)Matchers.isA(RequestLine.class))).thenReturn((Object)this.mockHttpMessageReceiver);
        this.setUpSocketMessage();
        Mockito.when((Object)this.mockHttpMessageReceiver.createMessageContext((HttpServerConnection)Matchers.isA(HttpServerConnection.class))).thenReturn((Object)this.mockMessageContext);
        httpRequestDispatcherWork.run();
        ((HttpMessageReceiver)Mockito.verify((Object)this.mockHttpMessageReceiver, (VerificationMode)Mockito.times((int)1))).processRequest((HttpServerConnection)Matchers.isA(HttpServerConnection.class));
    }

    private void setUpSocketMessage() throws IOException {
        Mockito.when((Object)this.mockHttpConnector.getMuleContext().getConfiguration().getDefaultEncoding()).thenReturn((Object)"UTF-8");
        Mockito.when((Object)this.mockSocket.getInputStream()).thenReturn((Object)new ByteArrayInputStream("GET /path/to/file/index.html HTTP/1.0\n".getBytes()));
    }
}

