/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.Socket;
import java.util.Collections;
import java.util.Map;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.SSLSocket;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.DefaultMuleMessage;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.service.Service;
import org.mule.api.transport.Connector;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.transport.http.HttpConnector;
import org.mule.transport.http.HttpMessageProcessTemplate;
import org.mule.transport.http.HttpServerConnection;
import org.mule.transport.http.HttpsConnector;
import org.mule.transport.http.HttpsMessageReceiver;
import org.mule.transport.ssl.MockHandshakeCompletedEvent;
import org.mule.transport.ssl.MockSslSocket;

public class HttpsHandshakeTimingTestCase
extends AbstractMuleContextTestCase {
    @Test(expected=MessagingException.class)
    public void testHttpsHandshakeExceedsTimeout() throws Exception {
        MockHttpsMessageReceiver messageReceiver = this.setupMockHttpsMessageReceiver();
        MockSslSocket socket = new MockSslSocket();
        HttpMessageProcessTemplate messageProcessTemplate = messageReceiver.createMessageContext(new HttpServerConnection((Socket)socket, messageReceiver.getEndpoint().getEncoding(), (HttpConnector)messageReceiver.getConnector()));
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"Test Message", muleContext);
        messageProcessTemplate.beforeRouteEvent(HttpsHandshakeTimingTestCase.getTestEvent((Object)message));
    }

    @Test
    public void testHttpsHandshakeCompletesBeforeProcessingMessage() throws Exception {
        MockHttpsMessageReceiver messageReceiver = this.setupMockHttpsMessageReceiver();
        MockSslSocket socket = new MockSslSocket();
        socket.setInputStream((InputStream)new ByteArrayInputStream("GET /path/to/file/index.html HTTP/1.0\n\n\n".getBytes()));
        HttpServerConnection serverConnection = new HttpServerConnection((Socket)socket, "utf-8", (HttpConnector)messageReceiver.getConnector());
        HttpMessageProcessTemplate messageContext = messageReceiver.createMessageContext(serverConnection);
        this.invokeHandshakeCompleted(serverConnection, socket);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"Test Message", muleContext);
        messageContext.acquireMessage();
        serverConnection.readRequest();
        MuleEvent muleEvent = messageContext.beforeRouteEvent(HttpsHandshakeTimingTestCase.getTestEvent((Object)message));
        Assert.assertNotNull((Object)muleEvent.getMessage().getOutboundProperty("LOCAL_CERTIFICATES"));
        Assert.assertNotNull((Object)muleEvent.getMessage().getOutboundProperty("PEER_CERTIFICATES"));
    }

    private void invokeHandshakeCompleted(HttpServerConnection serverConnection, MockSslSocket socket) throws Exception {
        MockHandshakeCompletedEvent event = new MockHandshakeCompletedEvent((SSLSocket)socket);
        serverConnection.handshakeCompleted((HandshakeCompletedEvent)event);
    }

    private MockHttpsMessageReceiver setupMockHttpsMessageReceiver() throws CreateException {
        HttpsConnector httpsConnector = new HttpsConnector(muleContext);
        httpsConnector.setSslHandshakeTimeout(1000L);
        Map properties = Collections.emptyMap();
        InboundEndpoint inboundEndpoint = (InboundEndpoint)Mockito.mock(InboundEndpoint.class);
        Mockito.when((Object)inboundEndpoint.getConnector()).thenReturn((Object)httpsConnector);
        Mockito.when((Object)inboundEndpoint.getProperties()).thenReturn(properties);
        Service service = (Service)Mockito.mock(Service.class);
        return new MockHttpsMessageReceiver((Connector)httpsConnector, (FlowConstruct)service, inboundEndpoint);
    }

    private static class MockHttpsMessageReceiver
    extends HttpsMessageReceiver {
        public MockHttpsMessageReceiver(Connector connector, FlowConstruct flowConstruct, InboundEndpoint endpoint) throws CreateException {
            super(connector, flowConstruct, endpoint);
        }
    }
}

