/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.functional;

import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.api.MuleEventContext;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.TransformerException;
import org.mule.config.i18n.LocaleMessageHandler;
import org.mule.module.client.MuleClient;
import org.mule.tck.functional.EventCallback;
import org.mule.tck.functional.FunctionalTestComponent;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.transformer.AbstractTransformer;
import org.mule.util.SystemUtils;
import org.mule.util.concurrent.Latch;

public class HttpEncodingNonAsciiFunctionalTestCase
extends FunctionalTestCase {
    private static final String ENCODING_JP = "ISO-2022-JP";
    private static final String FORM_ENCODED_CONTENT_TYPE_HEADER = "application/x-www-form-urlencoded; charset=ISO-2022-JP";
    private static final String PLAIN_CONTENT_TYPE_HEADER = "text/plain; charset=ISO-2022-JP";
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");

    protected String getConfigResources() {
        return "http-encoding-non-ascii-test.xml";
    }

    protected boolean isDisabledInThisEnvironment() {
        return SystemUtils.isIbmJDK();
    }

    @Test
    public void testSendViaGET() throws Exception {
        Latch latch = new Latch();
        this.setupAssertIncomingMessage("GET", latch, PLAIN_CONTENT_TYPE_HEADER);
        String testMessage = this.getTestMessage(Locale.JAPAN);
        String encodedPayload = URLEncoder.encode(testMessage, ENCODING_JP);
        String url = String.format("http://localhost:%1d/get?%2s=%3s", this.dynamicPort.getNumber(), "body", encodedPayload);
        GetMethod method = new GetMethod(url);
        method.addRequestHeader("Content-Type", PLAIN_CONTENT_TYPE_HEADER);
        int status = new HttpClient().executeMethod((HttpMethod)method);
        Assert.assertEquals((long)200L, (long)status);
        Assert.assertTrue((boolean)latch.await(5000L, TimeUnit.MILLISECONDS));
        String expected = testMessage + " Received";
        String response = method.getResponseBodyAsString();
        Assert.assertEquals((Object)expected, (Object)response);
        Header responseContentType = method.getResponseHeader("Content-Type");
        Assert.assertEquals((Object)"text/plain;charset=EUC-JP", (Object)responseContentType.getValue());
    }

    @Test
    public void testSendViaPOST() throws Exception {
        String payload = this.getTestMessage(Locale.JAPAN);
        HashMap<String, Object> messageProperties = new HashMap<String, Object>();
        messageProperties.put("MULE_ENCODING", ENCODING_JP);
        this.doTestSend("POST", payload, messageProperties, PLAIN_CONTENT_TYPE_HEADER);
    }

    @Test
    public void testSendViaPostMap() throws Exception {
        HashMap<String, String> messagePayload = new HashMap<String, String>();
        messagePayload.put("body", this.getTestMessage(Locale.JAPAN));
        HashMap<String, Object> messageProperties = new HashMap<String, Object>();
        messageProperties.put("MULE_ENCODING", ENCODING_JP);
        this.doTestSend("POSTMap", messagePayload, messageProperties, FORM_ENCODED_CONTENT_TYPE_HEADER);
    }

    private void doTestSend(String method, Object messagePayload, Map<String, Object> messageProperties, String expectedContentTypeHeader) throws Exception {
        Latch latch = new Latch();
        this.setupAssertIncomingMessage(method, latch, expectedContentTypeHeader);
        MuleClient client = new MuleClient(muleContext);
        MuleMessage reply = client.send("vm://sendBy" + method, messagePayload, messageProperties);
        Assert.assertTrue((boolean)latch.await(5000L, TimeUnit.MILLISECONDS));
        Assert.assertNotNull((Object)reply);
        Assert.assertEquals((Object)"EUC-JP", (Object)reply.getEncoding());
        Assert.assertEquals((Object)(this.getTestMessage(Locale.JAPAN) + " Received"), (Object)reply.getPayloadAsString());
    }

    private void setupAssertIncomingMessage(String method, final Latch latch, final String expectedContentTypeHeader) throws Exception {
        FunctionalTestComponent ftc = this.getFunctionalTestComponent("testReceive" + method);
        ftc.setEventCallback(new EventCallback(){

            public void eventReceived(MuleEventContext context, Object serviceComponent) throws Exception {
                MuleMessage message = context.getMessage();
                junit.framework.Assert.assertEquals((Object)expectedContentTypeHeader, (Object)message.getInboundProperty("Content-Type", null));
                junit.framework.Assert.assertEquals((String)HttpEncodingNonAsciiFunctionalTestCase.ENCODING_JP, (String)message.getEncoding());
                Object payload = message.getPayload();
                if (payload instanceof String) {
                    Assert.assertEquals((Object)HttpEncodingNonAsciiFunctionalTestCase.this.getTestMessage(Locale.JAPAN), (Object)payload);
                } else {
                    Assert.fail();
                }
                latch.countDown();
            }
        });
    }

    private String getTestMessage(Locale locale) {
        return LocaleMessageHandler.getString((String)"test-data", (Locale)locale, (String)"HttpEncodingNonAsciiFunctionalTestCase.getMessage", (Object[])new Object[0]);
    }

    public static class ParamMapToString
    extends AbstractTransformer {
        protected Object doTransform(Object src, String outputEncoding) throws TransformerException {
            Map map = (Map)src;
            return map.get("body");
        }
    }
}

