/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.functional;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.transformer.DataType;
import org.mule.module.client.MuleClient;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class TwoEndpointsSinglePortTestCase
extends AbstractServiceAndFlowTestCase {
    @Rule
    public DynamicPort port1 = new DynamicPort("port1");

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "two-endpoints-single-port-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "two-endpoints-single-port-flow.xml"});
    }

    public TwoEndpointsSinglePortTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Test
    public void testSendToEach() throws Exception {
        this.sendWithResponse("inMyComponent1", "test", "mycomponent1", 10);
        this.sendWithResponse("inMyComponent2", "test", "mycomponent2", 10);
    }

    @Test
    public void testSendToEachWithBadEndpoint() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        this.sendWithResponse("inMyComponent1", "test", "mycomponent1", 5);
        this.sendWithResponse("inMyComponent2", "test", "mycomponent2", 5);
        String url = String.format("http://localhost:%d/mycomponent-notfound", this.port1.getNumber());
        MuleMessage result = client.send(url, (Object)"test", null);
        Assert.assertNotNull((Object)result);
        Assert.assertNotNull((Object)result.getExceptionPayload());
        int status = (Integer)result.getInboundProperty("http.status", (Object)0);
        Assert.assertEquals((long)404L, (long)status);
        this.sendWithResponse("inMyComponent1", "test", "mycomponent1", 5);
        this.sendWithResponse("inMyComponent2", "test", "mycomponent2", 5);
    }

    protected void sendWithResponse(String endPointName, String message, String response, int noOfMessages) throws MuleException {
        int i;
        MuleClient client = new MuleClient(muleContext);
        ArrayList<Object> results = new ArrayList<Object>();
        for (i = 0; i < noOfMessages; ++i) {
            results.add(client.send(((InboundEndpoint)client.getMuleContext().getRegistry().lookupObject(endPointName)).getAddress(), (Object)message, null).getPayload(DataType.BYTE_ARRAY_DATA_TYPE));
        }
        Assert.assertEquals((long)noOfMessages, (long)results.size());
        for (i = 0; i < noOfMessages; ++i) {
            Assert.assertEquals((Object)response, (Object)new String((byte[])results.get(i)));
        }
    }
}

