/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.issues;

import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleEventContext;
import org.mule.api.MuleMessage;
import org.mule.module.client.MuleClient;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.functional.EventCallback;
import org.mule.tck.functional.FunctionalTestComponent;
import org.mule.tck.junit4.rule.DynamicPort;

public class HttpMessageReceiverMule4456TestCase
extends AbstractServiceAndFlowTestCase {
    private static final String MESSAGE = "test message";
    private HttpClient httpClient;
    private MuleClient muleClient;
    @Rule
    public DynamicPort dynamicPort1 = new DynamicPort("port1");
    @Rule
    public DynamicPort dynamicPort2 = new DynamicPort("port2");

    public HttpMessageReceiverMule4456TestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "http-receiver-mule4456-config-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "http-receiver-mule4456-config-flow.xml"});
    }

    protected boolean isGracefulShutdown() {
        return true;
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        HttpClientParams params = new HttpClientParams();
        params.setVersion(HttpVersion.HTTP_1_1);
        this.httpClient = new HttpClient(params);
        this.muleClient = new MuleClient(muleContext);
    }

    @Test
    public void testAsyncPost() throws Exception {
        FunctionalTestComponent component = this.getFunctionalTestComponent("AsyncService");
        component.setEventCallback(new EventCallback(){

            public void eventReceived(MuleEventContext context, Object comp) throws Exception {
                Thread.sleep(200L);
                context.getMessageAsString();
            }
        });
        PostMethod request = new PostMethod("http://localhost:" + this.dynamicPort1.getNumber());
        StringRequestEntity entity = new StringRequestEntity(MESSAGE, "text/plain", muleContext.getConfiguration().getDefaultEncoding());
        request.setRequestEntity((RequestEntity)entity);
        this.httpClient.executeMethod((HttpMethod)request);
        MuleMessage message = this.muleClient.request("vm://out", 1000L);
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((Object)MESSAGE, (Object)message.getPayloadAsString());
    }

    @Test
    public void testAsyncPostWithPersistentSedaQueue() throws Exception {
        FunctionalTestComponent component = this.getFunctionalTestComponent("AsyncPersistentQueueService");
        component.setEventCallback(new EventCallback(){

            public void eventReceived(MuleEventContext context, Object comp) throws Exception {
                Thread.sleep(200L);
                context.getMessageAsString();
            }
        });
        PostMethod request = new PostMethod("http://localhost:" + this.dynamicPort2.getNumber());
        StringRequestEntity entity = new StringRequestEntity(MESSAGE, "text/plain", muleContext.getConfiguration().getDefaultEncoding());
        request.setRequestEntity((RequestEntity)entity);
        this.httpClient.executeMethod((HttpMethod)request);
        MuleMessage message = this.muleClient.request("vm://out", 1000L);
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((Object)MESSAGE, (Object)message.getPayloadAsString());
    }
}

