/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http;

import java.io.IOException;
import java.net.URI;
import javax.resource.spi.work.ExecutionContext;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkListener;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.mule.api.MuleContext;
import org.mule.api.context.WorkManager;
import org.mule.api.endpoint.EndpointException;
import org.mule.api.endpoint.EndpointURI;
import org.mule.endpoint.MuleEndpointURI;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.transport.ConnectException;
import org.mule.transport.http.HttpConnectionManager;
import org.mule.transport.http.HttpConnector;
import org.mule.transport.http.HttpRequestDispatcher;

@RunWith(value=MockitoJUnitRunner.class)
@SmallTest
public class HttpConnectionManagerTestCase
extends AbstractMuleTestCase {
    public static final String DEFAULT_ENDPOINT_URI = "http://localhost:1234/";
    public static final String NESTED_ENDPOINT_URI_1 = "http://localhost:1234/service";
    public static final String NESTED_ENDPOINT_URI_2 = "http://localhost:1234/service/order";
    public static final String ANOTHER_ENDPOINT_URI = "http://localhost:1235/service";
    public static final String ANOTHER_NESTED_ENDPOINT_URI = "http://localhost:1235/service/order";
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private WorkManager mockWorkManager;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private HttpConnector mockHttpConnector;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private MuleContext mockMuleContext;

    @Test(expected=IllegalArgumentException.class)
    public void constructorWithNullWorkManager() {
        new HttpConnectionManager(this.mockHttpConnector, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void constructorWithNullConnector() {
        new HttpConnectionManager(null, this.mockWorkManager);
    }

    @Test(expected=ConnectException.class)
    public void workSchedulingFails() throws Exception {
        Mockito.when((Object)this.mockHttpConnector.getServerSocket((URI)Matchers.any(URI.class))).thenThrow(new Class[]{IOException.class});
        this.createConnectionManagerAndAddDefaultEndpointUri();
    }

    @Test
    public void removeConnectionWithoutDispatcherDoesntFail() throws Exception {
        HttpConnectionManager connectionManager = new HttpConnectionManager(this.mockHttpConnector, this.mockWorkManager);
        connectionManager.removeConnection((EndpointURI)new MuleEndpointURI("http://localhost:1234/service/path", this.mockMuleContext));
    }

    @Test
    public void addConnectionStartsSocketDispatcher() throws Exception {
        this.createConnectionManagerAndAddDefaultEndpointUri();
        ((WorkManager)Mockito.verify((Object)this.mockWorkManager, (VerificationMode)Mockito.times((int)1))).scheduleWork((Work)Matchers.any(HttpRequestDispatcher.class), Matchers.anyLong(), (ExecutionContext)Matchers.any(ExecutionContext.class), (WorkListener)Matchers.any(WorkListener.class));
    }

    @Test
    public void add3EndpointUrisToSameHostPortOnlyExecutesOneDispatcher() throws Exception {
        HttpConnectionManager connectionManager = this.createConnectionManagerAndAddDefaultEndpointUri();
        connectionManager.addConnection((EndpointURI)this.createEndpointUri(NESTED_ENDPOINT_URI_1));
        connectionManager.addConnection((EndpointURI)this.createEndpointUri(NESTED_ENDPOINT_URI_2));
        ((WorkManager)Mockito.verify((Object)this.mockWorkManager, (VerificationMode)Mockito.times((int)1))).scheduleWork((Work)Matchers.any(HttpRequestDispatcher.class), Matchers.anyLong(), (ExecutionContext)Matchers.any(ExecutionContext.class), (WorkListener)Matchers.any(WorkListener.class));
    }

    @Test
    public void addEndpointsToDifferentHostPortOpensSeveralConnections() throws Exception {
        HttpConnectionManager connectionManager = this.createConnectionManagerAndAddDefaultEndpointUri();
        connectionManager.addConnection((EndpointURI)this.createEndpointUri(NESTED_ENDPOINT_URI_1));
        connectionManager.addConnection((EndpointURI)this.createEndpointUri(NESTED_ENDPOINT_URI_2));
        connectionManager.addConnection((EndpointURI)this.createEndpointUri(ANOTHER_ENDPOINT_URI));
        connectionManager.addConnection((EndpointURI)this.createEndpointUri(ANOTHER_NESTED_ENDPOINT_URI));
        ((WorkManager)Mockito.verify((Object)this.mockWorkManager, (VerificationMode)Mockito.times((int)2))).scheduleWork((Work)Matchers.any(HttpRequestDispatcher.class), Matchers.anyLong(), (ExecutionContext)Matchers.any(ExecutionContext.class), (WorkListener)Matchers.any(WorkListener.class));
    }

    @Test
    public void disposeShutdownsEverything() throws Exception {
        HttpConnectionManager connectionManager = this.createConnectionManagerAndAddDefaultEndpointUri();
        connectionManager.dispose();
        ((WorkManager)Mockito.verify((Object)this.mockWorkManager, (VerificationMode)Mockito.times((int)1))).dispose();
    }

    private HttpConnectionManager createConnectionManagerAndAddDefaultEndpointUri() throws ConnectException, EndpointException {
        HttpConnectionManager connectionManager = new HttpConnectionManager(this.mockHttpConnector, this.mockWorkManager);
        connectionManager.addConnection((EndpointURI)this.createEndpointUri(DEFAULT_ENDPOINT_URI));
        return connectionManager;
    }

    private MuleEndpointURI createEndpointUri(String uri) throws EndpointException {
        return new MuleEndpointURI(uri, this.mockMuleContext);
    }
}

