/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.junit.Assert;
import org.junit.Test;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.transport.http.transformers.MuleMessageToHttpResponse;

@SmallTest
public class HttpDateTestCase
extends AbstractMuleTestCase {
    @Test
    public void testParsingBackwardsCompatibility() {
        String[] dates;
        String originalFormat = "EEE, dd MMM yyyy hh:mm:ss zzz";
        SimpleDateFormat originalFormatter = new SimpleDateFormat(originalFormat, Locale.US);
        for (String date : dates = new String[]{"Tue, 15 Nov 1994 08:12:31 GMT", "Tue, 15 Nov 1994 08:12:31 -0300", "Tue, 15 Nov 1994 08:12:31 +0400", "Tue, 15 Nov 1994 08:12:31 +0230", "Tue, 15 Nov 1994 08:12:31 PST", "Tue, 15 Jun 1994 08:12:31 PDT", "Tue, 15 Nov 2013 00:00:00 EST", "Tue, 15 Nov 2013 23:59:59 EST", "Thu, 28 Mar 2013 13:15:40 -0700"}) {
            long originalMillis = 0L;
            try {
                originalMillis = originalFormatter.parse(date).getTime();
            }
            catch (ParseException e) {
                Assert.fail((String)("Parsing failed with original parser: " + date));
            }
            String newDateStr = MuleMessageToHttpResponse.formatDate((long)originalMillis);
            try {
                long newMillis = originalFormatter.parse(newDateStr).getTime();
                Assert.assertEquals((String)("Dates don't match for date: " + date), (long)originalMillis, (long)newMillis);
            }
            catch (ParseException e) {
                Assert.fail((String)("Old formatter failed to parse output of new formatter so it isn't backwards compatible. original: " + date + " new: " + newDateStr));
            }
        }
    }
}

