/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http;

import java.io.IOException;
import java.lang.reflect.Field;
import java.net.ServerSocket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.mule.api.context.WorkManager;
import org.mule.api.exception.SystemExceptionHandler;
import org.mule.api.retry.RetryCallback;
import org.mule.api.retry.RetryContext;
import org.mule.api.retry.RetryPolicyTemplate;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.transport.AbstractConnector;
import org.mule.transport.ConnectorLifecycleManager;
import org.mule.transport.http.HttpConnector;
import org.mule.transport.http.HttpRequestDispatcher;
import org.mule.transport.http.HttpRequestDispatcherWork;
import org.mule.util.concurrent.Latch;

@RunWith(value=MockitoJUnitRunner.class)
@SmallTest
public class HttpRequestDispatcherTestCase
extends AbstractMuleTestCase {
    public static final int WAIT_TIME = 5000;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private HttpConnector mockHttpConnector;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private WorkManager mockWorkManager;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ServerSocket mockServerSocket;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private RetryPolicyTemplate mockRetryTemplate;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ConnectorLifecycleManager mockConnectorLifecycleManager;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private RetryContext mockRetryContext;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private SystemExceptionHandler mockExceptionListener;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ExecutorService mockExecutor;

    @Test(expected=IllegalArgumentException.class)
    public void createHttpSocketDispatcherWithNullConnector() {
        new HttpRequestDispatcher(null, this.mockRetryTemplate, this.mockServerSocket, this.mockWorkManager);
    }

    @Test(expected=IllegalArgumentException.class)
    public void createHttpSocketDispatcherWithNullRetryPolicyTemplate() {
        new HttpRequestDispatcher(this.mockHttpConnector, null, this.mockServerSocket, this.mockWorkManager);
    }

    @Test(expected=IllegalArgumentException.class)
    public void createHttpSocketDispatcherWithNullServerSocket() {
        new HttpRequestDispatcher(this.mockHttpConnector, this.mockRetryTemplate, null, this.mockWorkManager);
    }

    @Test(expected=IllegalArgumentException.class)
    public void createHttpSocketDispatcherWithNullWorkManager() {
        new HttpRequestDispatcher(this.mockHttpConnector, this.mockRetryTemplate, this.mockServerSocket, null);
    }

    @Test
    public void closeServerSocketWhenDisconnect() throws IOException {
        HttpRequestDispatcher httpRequestDispatcher = new HttpRequestDispatcher(this.mockHttpConnector, this.mockRetryTemplate, this.mockServerSocket, this.mockWorkManager);
        httpRequestDispatcher.disconnect();
        ((ServerSocket)Mockito.verify((Object)this.mockServerSocket, (VerificationMode)Mockito.times((int)1))).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void whenFailureCallSystemExceptionHandler() throws Exception {
        HttpRequestDispatcher httpRequestDispatcher = new HttpRequestDispatcher(this.mockHttpConnector, this.mockRetryTemplate, this.mockServerSocket, this.mockWorkManager);
        final Latch acceptCalledLath = new Latch();
        this.sustituteLifecycleManager();
        Mockito.when((Object)this.mockConnectorLifecycleManager.getState().isStarted()).thenReturn((Object)true);
        Mockito.when((Object)this.mockRetryTemplate.execute((RetryCallback)Mockito.any(RetryCallback.class), (WorkManager)Mockito.any(WorkManager.class))).thenAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                acceptCalledLath.release();
                throw new Exception();
            }
        });
        Mockito.when((Object)this.mockHttpConnector.getMuleContext().getExceptionListener()).thenReturn((Object)this.mockExceptionListener);
        Thread dispatcherThread = this.createDispatcherThread(httpRequestDispatcher);
        try {
            dispatcherThread.start();
            if (!acceptCalledLath.await(5000L, TimeUnit.MILLISECONDS)) {
                Assert.fail((String)"retry template should be executed");
            }
            ((SystemExceptionHandler)Mockito.verify((Object)this.mockExceptionListener, (VerificationMode)Mockito.atLeast((int)1))).handleException((Exception)Mockito.isA(Exception.class));
        }
        finally {
            httpRequestDispatcher.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void whenConnectorIsNotStartedDoNotAcceptSockets() throws Exception {
        HttpRequestDispatcher httpRequestDispatcher = new HttpRequestDispatcher(this.mockHttpConnector, this.mockRetryTemplate, this.mockServerSocket, this.mockWorkManager);
        this.sustituteLifecycleManager();
        Mockito.when((Object)this.mockConnectorLifecycleManager.getState().isStarted()).thenReturn((Object)false);
        Mockito.when((Object)this.mockHttpConnector.isStarted()).thenReturn((Object)false);
        Thread dispatcherThread = this.createDispatcherThread(httpRequestDispatcher);
        try {
            dispatcherThread.start();
            ((RetryPolicyTemplate)Mockito.verify((Object)this.mockRetryTemplate, (VerificationMode)Mockito.times((int)0))).execute((RetryCallback)Mockito.any(RetryCallback.class), (WorkManager)Mockito.any(WorkManager.class));
        }
        finally {
            httpRequestDispatcher.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void whenSocketAcceptedExecuteWork() throws Exception {
        HttpRequestDispatcher httpRequestDispatcher = new HttpRequestDispatcher(this.mockHttpConnector, this.mockRetryTemplate, this.mockServerSocket, this.mockWorkManager);
        httpRequestDispatcher.requestHandOffExecutor = this.mockExecutor;
        final Latch acceptCalledLath = new Latch();
        this.sustituteLifecycleManager();
        Mockito.when((Object)this.mockConnectorLifecycleManager.getState().isStarted()).thenReturn((Object)true);
        Mockito.when((Object)this.mockRetryTemplate.execute((RetryCallback)Mockito.any(RetryCallback.class), (WorkManager)Mockito.any(WorkManager.class))).thenAnswer((Answer)new Answer<RetryContext>(){

            public RetryContext answer(InvocationOnMock invocationOnMock) throws Throwable {
                ((RetryCallback)invocationOnMock.getArguments()[0]).doWork(HttpRequestDispatcherTestCase.this.mockRetryContext);
                return null;
            }
        });
        ((ExecutorService)Mockito.doAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                acceptCalledLath.release();
                return null;
            }
        }).when((Object)this.mockExecutor)).execute((Runnable)Mockito.any(HttpRequestDispatcherWork.class));
        Thread dispatcherThread = this.createDispatcherThread(httpRequestDispatcher);
        dispatcherThread.start();
        try {
            if (!acceptCalledLath.await(500L, TimeUnit.MILLISECONDS)) {
                Assert.fail((String)"Work should have been scheduled");
            }
        }
        finally {
            httpRequestDispatcher.disconnect();
        }
    }

    private void sustituteLifecycleManager() throws NoSuchFieldException, IllegalAccessException {
        Field filed = AbstractConnector.class.getDeclaredField("lifecycleManager");
        filed.setAccessible(true);
        filed.set(this.mockHttpConnector, this.mockConnectorLifecycleManager);
    }

    private Thread createDispatcherThread(final HttpRequestDispatcher httpRequestDispatcher) {
        Thread requestDispatcherThread = new Thread(){

            @Override
            public void run() {
                httpRequestDispatcher.run();
            }
        };
        requestDispatcherThread.setDaemon(true);
        return requestDispatcherThread;
    }
}

