/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.builder;

import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.transport.http.builder.HttpResponseDefinitionParser;

@SmallTest
public class HttpResponseDefinitionParserTransformerTestCase
extends AbstractMuleTestCase {
    private HttpResponseDefinitionParser httpResponseDefinitionParser;

    @Before
    public void setUp() {
        this.httpResponseDefinitionParser = new HttpResponseDefinitionParser("header");
    }

    @Test
    public void testProcessHeaderName() {
        Map<String, String> headerNameMapping = this.populateHeaderNamesMapping();
        for (String headerName : headerNameMapping.keySet()) {
            String processedHeaderName = this.httpResponseDefinitionParser.processHeaderName(headerName);
            Assert.assertEquals((Object)headerNameMapping.get(headerName), (Object)processedHeaderName);
        }
    }

    private Map<String, String> populateHeaderNamesMapping() {
        HashMap<String, String> headerNameMapping = new HashMap<String, String>();
        headerNameMapping.put("cache-control", "Cache-Control");
        headerNameMapping.put("location", "Location");
        headerNameMapping.put("expires", "Expires");
        return headerNameMapping;
    }
}

