/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.functional;

import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.module.client.MuleClient;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class Http10FunctionalTestCase
extends AbstractServiceAndFlowTestCase {
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "http-10-config-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "http-10-config-flow.xml"});
    }

    public Http10FunctionalTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    private HttpClient setupHttpClient() {
        HttpClientParams params = new HttpClientParams();
        params.setVersion(HttpVersion.HTTP_1_0);
        return new HttpClient(params);
    }

    @Test
    public void testHttp10EnforceNonChunking() throws Exception {
        HttpClient client = this.setupHttpClient();
        MuleClient muleClient = new MuleClient(muleContext);
        GetMethod request = new GetMethod(((InboundEndpoint)muleClient.getMuleContext().getRegistry().lookupObject("inStreaming")).getAddress());
        client.executeMethod((HttpMethod)request);
        Assert.assertEquals((Object)"hello", (Object)request.getResponseBodyAsString());
        Assert.assertNull((Object)request.getResponseHeader("Transfer-Encoding"));
        Assert.assertNotNull((Object)request.getResponseHeader("Content-Length"));
    }
}

