/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.functional;

import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleEventContext;
import org.mule.api.MuleMessage;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.functional.EventCallback;
import org.mule.tck.functional.FunctionalTestComponent;
import org.mule.tck.junit4.rule.DynamicPort;

public class HttpPersistentQueueTestCase
extends AbstractServiceAndFlowTestCase {
    private CountDownLatch messageDidArrive = new CountDownLatch(1);
    private int port = -1;
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");

    public HttpPersistentQueueTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "http-persistent-queue-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "http-persistent-queue-flow.xml"});
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        FunctionalTestComponent testComponent = (FunctionalTestComponent)this.getComponent("PersistentQueueAsync");
        Assert.assertNotNull((Object)testComponent);
        testComponent.setEventCallback((EventCallback)new Callback(this.messageDidArrive));
        this.port = this.dynamicPort.getNumber();
    }

    @Test
    public void testPersistentMessageDeliveryWithGet() throws Exception {
        GetMethod method = new GetMethod("http://localhost:" + this.port + "/services/Echo?foo=bar");
        method.addRequestHeader("Connection", "close");
        this.doTestPersistentMessageDelivery((HttpMethod)method);
    }

    @Test
    public void testPersistentMessageDeliveryWithPost() throws Exception {
        PostMethod method = new PostMethod("http://localhost:" + this.port + "/services/Echo");
        method.addRequestHeader("Connection", "close");
        method.addParameter(new NameValuePair("foo", "bar"));
        this.doTestPersistentMessageDelivery((HttpMethod)method);
    }

    private void doTestPersistentMessageDelivery(HttpMethod httpMethod) throws Exception {
        HttpClient client = new HttpClient();
        int rc = client.executeMethod(httpMethod);
        Assert.assertEquals((long)200L, (long)rc);
        Assert.assertTrue((boolean)this.messageDidArrive.await(5000L, TimeUnit.MILLISECONDS));
    }

    private static class Callback
    implements EventCallback {
        private CountDownLatch messageDidArrive;

        public Callback(CountDownLatch latch) {
            this.messageDidArrive = latch;
        }

        public void eventReceived(MuleEventContext context, Object component) throws Exception {
            MuleMessage message = context.getMessage();
            Object httpMethod = message.getInboundProperty("http.method");
            if ("GET".equals(httpMethod)) {
                Assert.assertEquals((Object)"/services/Echo?foo=bar", (Object)message.getPayloadAsString());
            } else if ("POST".equals(httpMethod)) {
                Assert.assertEquals((Object)"foo=bar", (Object)message.getPayloadAsString());
            } else {
                Assert.fail((String)("invalid HTTP method : " + httpMethod));
            }
            Assert.assertEquals((Object)"true", (Object)message.getInboundProperty("Connection"));
            Assert.assertEquals((Object)"true", (Object)message.getInboundProperty("Keep-Alive"));
            this.messageDidArrive.countDown();
        }
    }
}

