/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.servlet;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.servlet.ServletInputStream;
import junit.framework.Assert;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.io.IOUtils;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.EndpointException;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.registry.MuleRegistry;
import org.mule.api.transaction.TransactionConfig;
import org.mule.endpoint.MuleEndpointURI;
import org.mule.transport.http.servlet.MuleHttpServletRequest;
import org.mule.transport.http.servlet.MuleHttpServletResponse;

public class MuleServletTestCase
extends Assert {
    private MuleContext muleContext;
    private MuleRegistry registry;

    @Before
    public void setUp() {
        this.muleContext = (MuleContext)Mockito.mock(MuleContext.class);
        this.registry = (MuleRegistry)Mockito.mock(MuleRegistry.class);
        Mockito.when((Object)this.muleContext.getRegistry()).thenReturn((Object)this.registry);
    }

    @Test
    public void testHttpServletRequest() throws Exception {
        String queryParam = "array=1&array=2&param1=param1&noValueParam";
        DefaultMuleEvent event = this.getTestHttpEvent(queryParam);
        MuleHttpServletRequest request = new MuleHttpServletRequest((MuleEvent)event);
        ServletInputStream stream = request.getInputStream();
        MuleServletTestCase.assertNotNull((Object)stream);
        IOUtils.contentEquals((InputStream)new ByteArrayInputStream("test".getBytes()), (InputStream)stream);
        MuleServletTestCase.assertEquals((String)"value", (String)request.getHeader("X-MyHeader"));
        MuleServletTestCase.assertEquals((String)"UTF-8", (String)request.getCharacterEncoding());
        MuleServletTestCase.assertEquals((int)-1, (int)request.getContentLength());
        MuleServletTestCase.assertEquals((String)"text/plain", (String)request.getContentType());
        MuleServletTestCase.assertEquals((String)"/foo", (String)request.getContextPath());
        MuleServletTestCase.assertEquals((String)"GET", (String)request.getMethod());
        MuleServletTestCase.assertEquals((String)"/bar", (String)request.getPathInfo());
        MuleServletTestCase.assertEquals((String)queryParam, (String)request.getQueryString());
        MuleServletTestCase.assertEquals((String)"/foo/bar", (String)request.getRequestURI());
        MuleServletTestCase.assertEquals((String)"/foo", (String)request.getServletPath());
        MuleServletTestCase.assertEquals((String)"127.0.0.1", (String)request.getServerName());
    }

    @Test
    public void testNoQueryParams() throws Exception {
        DefaultMuleEvent event = this.getTestHttpEvent("");
        MuleHttpServletRequest request = new MuleHttpServletRequest((MuleEvent)event);
        MuleServletTestCase.assertEquals((String)"", (String)request.getQueryString());
    }

    @Test
    public void testResponse() throws Exception {
        DefaultMuleEvent event = this.getTestHttpEvent("");
        MuleMessage message = event.getMessage();
        MuleHttpServletResponse response = new MuleHttpServletResponse((MuleEvent)event);
        response.setStatus(404);
        MuleServletTestCase.assertEquals((Object)404, (Object)message.getOutboundProperty("http.status"));
        response.setStatus(200, "status message");
        MuleServletTestCase.assertEquals((Object)200, (Object)message.getOutboundProperty("http.status"));
        response.setContentType("application/octet-stream");
        MuleServletTestCase.assertEquals((Object)"application/octet-stream", (Object)message.getOutboundProperty("Content-Type"));
        MuleServletTestCase.assertEquals((String)"application/octet-stream", (String)response.getContentType());
        response.setHeader("X-Test", "value");
        MuleServletTestCase.assertTrue((boolean)response.containsHeader("X-Test"));
        MuleServletTestCase.assertEquals((Object)"value", (Object)message.getOutboundProperty("X-Test"));
        response.setDateHeader("X-Date", 0L);
        MuleServletTestCase.assertEquals((Object)"Wed, 31 Dec 1969 00:00:00 GMT", (Object)message.getOutboundProperty("X-Date"));
        response.sendRedirect("http://anotherplace");
        MuleServletTestCase.assertEquals((Object)"http://anotherplace", (Object)message.getOutboundProperty("Location"));
        MuleServletTestCase.assertEquals((Object)302, (Object)message.getOutboundProperty("http.status"));
    }

    @Test
    public void testCookies() throws Exception {
        DefaultMuleEvent event = this.getTestHttpEvent("");
        MuleMessage message = event.getMessage();
        MuleHttpServletResponse response = new MuleHttpServletResponse((MuleEvent)event);
        response.addCookie(new javax.servlet.http.Cookie("cookie1", "value"));
        Cookie[] cookies = (Cookie[])message.getOutboundProperty("cookies");
        MuleServletTestCase.assertNotNull((Object)cookies);
        Cookie cookie = cookies[0];
        MuleServletTestCase.assertEquals((String)"cookie1", (String)cookie.getName());
        MuleServletTestCase.assertEquals((String)"value", (String)cookie.getValue());
        response.addCookie(new javax.servlet.http.Cookie("cookie2", "value"));
        cookies = (Cookie[])message.getOutboundProperty("cookies");
        MuleServletTestCase.assertNotNull((Object)cookies);
        MuleServletTestCase.assertEquals((int)2, (int)cookies.length);
        cookie = cookies[1];
        MuleServletTestCase.assertEquals((String)"cookie2", (String)cookie.getName());
        MuleServletTestCase.assertEquals((String)"value", (String)cookie.getValue());
    }

    private DefaultMuleEvent getTestHttpEvent(String queryParam) throws EndpointException {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"payload", this.muleContext);
        message.setInboundProperty("X-MyHeader", (Object)"value");
        message.setInboundProperty("Content-Type", (Object)"text/plain");
        message.setInboundProperty("http.method", (Object)"GET");
        message.setInboundProperty("http.context.path", (Object)"/foo");
        message.setInboundProperty("http.request.path", (Object)"/foo/bar");
        if (queryParam != null) {
            queryParam = "?" + queryParam;
        }
        message.setInboundProperty("http.request", (Object)("/foo/bar" + queryParam));
        message.setInboundProperty("Host", (Object)"127.0.0.1");
        message.setEncoding("UTF-8");
        InboundEndpoint ep = (InboundEndpoint)Mockito.mock(InboundEndpoint.class);
        Mockito.when((Object)ep.getAddress()).thenReturn((Object)"http://localhost:8080/foo");
        Mockito.when((Object)ep.getName()).thenReturn((Object)"test");
        Mockito.when((Object)ep.getEndpointURI()).thenReturn((Object)new MuleEndpointURI("http://localhost:8080/foo", this.muleContext));
        TransactionConfig txConfig = (TransactionConfig)Mockito.mock(TransactionConfig.class);
        Mockito.when((Object)ep.getTransactionConfig()).thenReturn((Object)txConfig);
        Mockito.when((Object)ep.getExchangePattern()).thenReturn((Object)MessageExchangePattern.REQUEST_RESPONSE);
        DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)message, ep, (FlowConstruct)null);
        return event;
    }
}

