/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.transformers;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashSet;
import java.util.Locale;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Header;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.api.MuleMessage;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.transport.http.HttpResponse;
import org.mule.transport.http.transformers.MuleMessageToHttpResponse;

@SmallTest
public class MuleMessageToHttpResponseTestCase
extends AbstractMuleTestCase {
    @Test
    public void testSetCookieOnOutbound() throws Exception {
        MuleMessageToHttpResponse transformer = new MuleMessageToHttpResponse();
        MuleMessage msg = (MuleMessage)Mockito.mock(MuleMessage.class);
        Cookie[] cookiesOutbound = new Cookie[]{new Cookie("domain", "name-out-1", "value-out-1"), new Cookie("domain", "name-out-2", "value-out-2")};
        Mockito.when((Object)msg.getOutboundProperty("Set-Cookie")).thenReturn((Object)cookiesOutbound);
        HashSet<String> props = new HashSet<String>();
        props.add("Set-Cookie");
        Mockito.when((Object)msg.getOutboundPropertyNames()).thenReturn(props);
        HttpResponse response = transformer.createResponse(null, "UTF-8", msg);
        Header[] headers = response.getHeaders();
        int cookiesSet = 0;
        for (Header header : headers) {
            if (!"Set-Cookie".equals(header.getName())) continue;
            ++cookiesSet;
        }
        Assert.assertEquals((long)cookiesOutbound.length, (long)cookiesSet);
    }

    @Test
    public void testSetDateOnOutbound() throws Exception {
        MuleMessageToHttpResponse transformer = new MuleMessageToHttpResponse();
        MuleMessage msg = (MuleMessage)Mockito.mock(MuleMessage.class);
        HttpResponse response = transformer.createResponse(null, "UTF-8", msg);
        Header[] headers = response.getHeaders();
        boolean hasDateHeader = false;
        for (Header header : headers) {
            if (!"Date".equals(header.getName())) continue;
            hasDateHeader = true;
            SimpleDateFormat formatter = new SimpleDateFormat("EEE, dd MMM yyyy hh:mm:ss zzz", Locale.US);
            formatter.setLenient(false);
            try {
                formatter.parse(header.getValue());
            }
            catch (ParseException e) {
                formatter.setLenient(true);
                formatter.parse(header.getValue());
                formatter = new SimpleDateFormat("EEE, dd MMM yyyy hh:mm:ss zzz".replaceFirst("hh", "HH"), Locale.US);
                formatter.setLenient(false);
                formatter.parse(header.getValue());
            }
        }
        Assert.assertTrue((String)"Missing 'Date' header", (boolean)hasDateHeader);
    }
}

