/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http;

import java.net.Socket;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.transport.NoReceiverForEndpointException;
import org.mule.transport.http.HttpConnector;
import org.mule.transport.http.HttpMessageReceiver;
import org.mule.transport.http.HttpServerConnection;
import org.mule.transport.http.RequestLine;
import org.mule.transport.http.i18n.HttpMessages;
import org.mule.util.monitor.Expirable;

public class HttpRequestDispatcherWork
implements Runnable,
Expirable {
    private static Log logger = LogFactory.getLog(HttpRequestDispatcherWork.class);
    private HttpServerConnection httpServerConnection;
    private Socket socket;
    private HttpConnector httpConnector;

    public HttpRequestDispatcherWork(HttpConnector httpConnector, Socket socket) {
        if (httpConnector == null) {
            throw new IllegalArgumentException("HttpConnector can not be null");
        }
        if (socket == null) {
            throw new IllegalArgumentException("Socket can not be null");
        }
        this.httpConnector = httpConnector;
        this.socket = socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            long keepAliveTimeout = this.httpConnector.getKeepAliveTimeout();
            String encoding = this.httpConnector.getMuleContext().getConfiguration().getDefaultEncoding();
            this.httpServerConnection = new HttpServerConnection(this.socket, encoding, this.httpConnector);
            do {
                try {
                    RequestLine requestLine;
                    this.httpServerConnection.setKeepAlive(false);
                    if (keepAliveTimeout > 0L) {
                        this.httpConnector.getKeepAliveMonitor().addExpirable(keepAliveTimeout, TimeUnit.MILLISECONDS, (Expirable)this);
                    }
                    if ((requestLine = this.httpServerConnection.getRequestLine()) == null) continue;
                    try {
                        HttpMessageReceiver httpMessageReceiver = this.httpConnector.lookupReceiver(this.socket, requestLine);
                        httpMessageReceiver.processRequest(this.httpServerConnection);
                    }
                    catch (NoReceiverForEndpointException e) {
                        this.httpServerConnection.writeFailureResponse(404, HttpMessages.cannotBindToAddress(this.httpServerConnection.getFullUri()).toString());
                    }
                }
                finally {
                    this.httpConnector.getKeepAliveMonitor().removeExpirable((Expirable)this);
                    this.httpServerConnection.reset();
                }
            } while (this.httpServerConnection.isKeepAlive());
        }
        catch (HttpMessageReceiver.EmptyRequestException e) {
            logger.debug((Object)"Discarding request since content was empty");
        }
        catch (HttpMessageReceiver.FailureProcessingRequestException e) {
            logger.debug((Object)"Closing socket due to failure during request processing");
        }
        catch (Exception e) {
            this.httpConnector.getMuleContext().getExceptionListener().handleException(e);
        }
        finally {
            logger.debug((Object)"Closing HTTP connection.");
            if (this.httpServerConnection != null && this.httpServerConnection.isOpen()) {
                this.httpServerConnection.close();
                this.httpServerConnection = null;
            }
        }
    }

    public void expired() {
        if (this.httpServerConnection.isOpen()) {
            this.httpServerConnection.close();
        }
    }
}

