/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.Cookie;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class HttpResponseTestCase
extends FunctionalTestCase {
    private static final String HTTP_BODY = "<html><head></head><body><p>This is the response body</p></body></html>";
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");

    protected String getConfigFile() {
        return "http-response-conf.xml";
    }

    @Test
    public void testHttpResponseError() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("errorMessage", "ERROR !!!! ");
        DefaultMuleMessage muleMessage = new DefaultMuleMessage((Object)HTTP_BODY, properties, muleContext);
        MuleMessage response = client.send("http://localhost:" + this.dynamicPort.getNumber() + "/resources/error", (Object)muleMessage, properties);
        Assert.assertTrue((boolean)response.getPayloadAsString().contains("ERROR !!!!"));
        Assert.assertEquals((Object)"500", (Object)response.getInboundProperty("http.status"));
    }

    @Test
    public void testHttpResponseMove() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        DefaultMuleMessage muleMessage = new DefaultMuleMessage((Object)HTTP_BODY, muleContext);
        MuleMessage response = client.send("http://localhost:" + this.dynamicPort.getNumber() + "/resources/move", (MuleMessage)muleMessage);
        Assert.assertEquals((Object)HTTP_BODY, (Object)response.getPayloadAsString());
        Assert.assertEquals((Object)"301", (Object)response.getInboundProperty("http.status"));
        Assert.assertEquals((Object)"http://localhost:9090/resources/moved", (Object)response.getInboundProperty("Location"));
    }

    @Test
    public void testHttpResponseAll() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        DefaultMuleMessage muleMessage = new DefaultMuleMessage((Object)HTTP_BODY, muleContext);
        MuleMessage response = client.send("http://localhost:" + this.dynamicPort.getNumber() + "/resources/all", (MuleMessage)muleMessage);
        Assert.assertEquals((Object)"Custom body", (Object)response.getPayloadAsString());
        Assert.assertEquals((Object)"404", (Object)response.getInboundProperty("http.status"));
        Assert.assertEquals((Object)"public,no-cache,must-revalidate,max-age=3600,no-transform", (Object)response.getInboundProperty("Cache-Control"));
        Assert.assertEquals((Object)"Thu, 01 Dec 2014 16:00:00 GMT", (Object)response.getInboundProperty("Expires"));
        Assert.assertEquals((Object)"http://localhost:9090", (Object)response.getInboundProperty("Location"));
        Assert.assertEquals((Object)"value1", (Object)response.getInboundProperty("header1"));
        Cookie[] cookies = (Cookie[])response.getInboundProperty("Set-Cookie");
        Assert.assertEquals((long)2L, (long)cookies.length);
        this.validateCookie(cookies[0]);
        this.validateCookie(cookies[1]);
    }

    @Test
    public void testHttpResponseAllWithExpressions() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        Map<String, Object> properties = this.populateProperties();
        DefaultMuleMessage muleMessage = new DefaultMuleMessage((Object)HTTP_BODY, properties, muleContext);
        MuleMessage response = client.send("http://localhost:" + this.dynamicPort.getNumber() + "/resources/allExpressions", (Object)muleMessage, properties);
        Assert.assertEquals((Object)"404", (Object)response.getInboundProperty("http.status"));
        Assert.assertEquals((Object)"max-age=3600", (Object)response.getInboundProperty("Cache-Control"));
        Assert.assertEquals((Object)"Thu, 01 Dec 2014 16:00:00 GMT", (Object)response.getInboundProperty("Expires"));
        Assert.assertEquals((Object)"http://localhost:9090", (Object)response.getInboundProperty("Location"));
        Assert.assertEquals((Object)"value1", (Object)response.getInboundProperty("header1"));
        Cookie[] cookies = (Cookie[])response.getInboundProperty("Set-Cookie");
        Assert.assertEquals((long)2L, (long)cookies.length);
        this.validateCookie(cookies[0]);
        this.validateCookie(cookies[1]);
    }

    private Map<String, Object> populateProperties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("customBody", "Custom body");
        properties.put("contentType", "text/html");
        properties.put("status", 404);
        properties.put("cacheControl", "3600");
        properties.put("expires", "Thu, 01 Dec 2014 16:00:00 GMT");
        properties.put("location", "http://localhost:9090");
        properties.put("header1", "header1");
        properties.put("header2", "header2");
        properties.put("value1", "value1");
        properties.put("value2", "value2");
        properties.put("cookie1", "cookie1");
        properties.put("cookie2", "cookie2");
        properties.put("domain", "localhost");
        properties.put("path", "/");
        properties.put("secure", true);
        properties.put("expiryDate", "Fri, 12 Dec 2014 17:00:00 GMT");
        properties.put("maxAge", "1000");
        return properties;
    }

    private void validateCookie(Cookie cookie) {
        if ("cookie1".equals(cookie.getName())) {
            Assert.assertEquals((Object)"value1", (Object)cookie.getValue());
            Assert.assertEquals((Object)"/", (Object)cookie.getPath());
            Assert.assertEquals((Object)"localhost", (Object)cookie.getDomain());
            this.validateDate(cookie.getExpiryDate());
            Assert.assertTrue((boolean)cookie.getSecure());
        } else {
            Assert.assertEquals((Object)"cookie2", (Object)cookie.getName());
            Assert.assertEquals((Object)"value2", (Object)cookie.getValue());
            Assert.assertFalse((boolean)cookie.getSecure());
        }
    }

    private void validateDate(Date date) {
        GregorianCalendar cookieDate = new GregorianCalendar();
        cookieDate.setTime(date);
        Assert.assertEquals((long)2014L, (long)cookieDate.get(1));
        Assert.assertEquals((long)12L, (long)cookieDate.get(5));
        Assert.assertEquals((long)11L, (long)cookieDate.get(2));
    }
}

