/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.cert.Certificate;
import java.util.HashMap;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLSocket;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.size.SmallTest;
import org.mule.transport.http.HttpConnector;
import org.mule.transport.http.HttpRequest;
import org.mule.transport.http.HttpResponse;
import org.mule.transport.http.HttpServerConnection;

@RunWith(value=MockitoJUnitRunner.class)
@SmallTest
public class HttpServerConnectionTestCase
extends AbstractMuleContextTestCase {
    private static final boolean SEND_TCP_NO_DELAY = false;
    private static final boolean KEEP_ALIVE = true;
    private static final int RECEIVE_BUFFER_SIZE = 1024;
    private static final int SERVER_SO_TIMEOUT = 5000;
    public DynamicPort port1 = new DynamicPort("port1");
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private Socket mockSocket;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private SSLSocket mockSslSocket;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private HttpConnector mockHttpConnector;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private HandshakeCompletedEvent mockHandshakeCompleteEvent;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private HttpRequest mockHttpRequest;
    private Certificate[] mockLocalCertificate = new Certificate[2];
    private Certificate[] mockPeerCertificates = new Certificate[2];

    @Test
    public void createHttpServerConnectionWithSslSocket() throws IOException {
        Mockito.when((Object)this.mockHandshakeCompleteEvent.getLocalCertificates()).thenReturn((Object)this.mockLocalCertificate);
        Mockito.when((Object)this.mockHandshakeCompleteEvent.getPeerCertificates()).thenReturn((Object)this.mockPeerCertificates);
        ((SSLSocket)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocationOnMock) throws Throwable {
                ((HandshakeCompletedListener)invocationOnMock.getArguments()[0]).handshakeCompleted(HttpServerConnectionTestCase.this.mockHandshakeCompleteEvent);
                return null;
            }
        }).when((Object)this.mockSslSocket)).addHandshakeCompletedListener((HandshakeCompletedListener)Matchers.any(HandshakeCompletedListener.class));
        HttpServerConnection httpServerConnection = new HttpServerConnection((Socket)this.mockSslSocket, muleContext.getConfiguration().getDefaultEncoding(), this.mockHttpConnector);
        ((SSLSocket)Mockito.verify((Object)this.mockSslSocket, (VerificationMode)Mockito.times((int)1))).addHandshakeCompletedListener((HandshakeCompletedListener)httpServerConnection);
        Assert.assertThat((Object)httpServerConnection.getLocalCertificateChain(), (Matcher)Is.is((Object)this.mockLocalCertificate));
        Assert.assertThat((Object)httpServerConnection.getPeerCertificateChain(), (Matcher)Is.is((Object)this.mockPeerCertificates));
    }

    @Test(expected=IllegalStateException.class)
    public void createHttpServerConnectionWithSocketAndFailForLocalCertificates() throws Exception {
        HttpServerConnection httpServerConnection = new HttpServerConnection(this.mockSocket, muleContext.getConfiguration().getDefaultEncoding(), this.mockHttpConnector);
        httpServerConnection.getLocalCertificateChain();
    }

    @Test(expected=IllegalStateException.class)
    public void createHttpServerConnectionWithSocketAndFailForPeerCertificates() throws Exception {
        HttpServerConnection httpServerConnection = new HttpServerConnection(this.mockSocket, muleContext.getConfiguration().getDefaultEncoding(), this.mockHttpConnector);
        httpServerConnection.getPeerCertificateChain();
    }

    @Test(expected=IllegalStateException.class)
    public void createHttpServerConnectionWithSocketAndFailForHandshakeLatch() throws Exception {
        HttpServerConnection httpServerConnection = new HttpServerConnection(this.mockSocket, muleContext.getConfiguration().getDefaultEncoding(), this.mockHttpConnector);
        httpServerConnection.getSslSocketHandshakeCompleteLatch();
    }

    @Test
    public void resetConnectionReadNextRequest() throws Exception {
        this.configureValidRequestForSocketInputStream();
        HttpServerConnection httpServerConnection = new HttpServerConnection(this.mockSocket, muleContext.getConfiguration().getDefaultEncoding(), this.mockHttpConnector);
        Assert.assertThat((Object)httpServerConnection.getUrlWithoutRequestParams(), (Matcher)Is.is((Object)"/service/order"));
        httpServerConnection.reset();
        Assert.assertThat((Object)httpServerConnection.getUrlWithoutRequestParams(), (Matcher)Is.is((Object)"/"));
    }

    private void configureValidRequestForSocketInputStream() throws IOException {
        Mockito.when((Object)this.mockSocket.getInputStream()).thenReturn((Object)new ByteArrayInputStream(String.format("GET %s HTTP/1.1\n\nGET %s HTTP/1.1\n", "/service/order?param1=value1&param2=value2", "/?param1=value1&param2=value2").getBytes()));
    }

    @Test
    public void getRemoteSocketAddressWithNullSocketAddress() throws Exception {
        HttpServerConnection httpServerConnection = new HttpServerConnection(this.mockSocket, muleContext.getConfiguration().getDefaultEncoding(), this.mockHttpConnector);
        Mockito.when((Object)this.mockSocket.getRemoteSocketAddress()).thenReturn(null);
        Assert.assertThat((Object)httpServerConnection.getRemoteClientAddress(), (Matcher)IsNull.nullValue());
    }

    @Test
    public void getRemoteSocketAddress() throws Exception {
        HttpServerConnection httpServerConnection = new HttpServerConnection(this.mockSocket, muleContext.getConfiguration().getDefaultEncoding(), this.mockHttpConnector);
        Mockito.when((Object)this.mockSocket.getRemoteSocketAddress()).thenReturn((Object)new InetSocketAddress("host", 1000));
        Assert.assertThat((Object)httpServerConnection.getRemoteClientAddress(), (Matcher)Is.is((Object)"host:1000"));
    }

    @Test
    public void getUrlWithoutRequestParams() throws Exception {
        this.testUrlWithoutParams("/service/order?param1=value1&param2=value2", "/service/order");
        this.testUrlWithoutParams("/service/order", "/service/order");
        this.testUrlWithoutParams("/service?param1=value1&param2=value2", "/service");
        this.testUrlWithoutParams("/?param1=value1&param2=value2", "/");
        this.testUrlWithoutParams("/", "/");
    }

    @Test(expected=NullPointerException.class)
    public void writeResponseWithNullParams() throws Exception {
        ByteArrayOutputStream responseContent = new ByteArrayOutputStream();
        HttpServerConnection httpServerConnection = this.createHttpServerConnectionForResponseTest(responseContent);
        httpServerConnection.writeResponse(new HttpResponse(), null);
    }

    @Test
    public void writeResponseWithEmptyParams() throws Exception {
        ByteArrayOutputStream responseContent = new ByteArrayOutputStream();
        HttpServerConnection httpServerConnection = this.createHttpServerConnectionForResponseTest(responseContent);
        httpServerConnection.writeResponse(new HttpResponse(), new HashMap());
        String response = new String(responseContent.toByteArray());
        Assert.assertThat((Object)response.startsWith("HTTP/1.1 200 OK"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)response.contains("Connection: close"), (Matcher)Is.is((Object)true));
    }

    @Test
    public void writeResponseWithParams() throws Exception {
        ByteArrayOutputStream responseContent = new ByteArrayOutputStream();
        HttpServerConnection httpServerConnection = this.createHttpServerConnectionForResponseTest(responseContent);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("header1", "value1");
        headers.put("header2", "value2");
        httpServerConnection.writeResponse(new HttpResponse(), headers);
        String response = new String(responseContent.toByteArray());
        Assert.assertThat((Object)response.startsWith("HTTP/1.1 200 OK"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)response.contains("header1: value1"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)response.contains("header2: value2"), (Matcher)Is.is((Object)true));
    }

    @Test(expected=NullPointerException.class)
    public void writeFailureResponseWithNullParams() throws Exception {
        ByteArrayOutputStream responseContent = new ByteArrayOutputStream();
        HttpServerConnection httpServerConnection = this.createHttpServerConnectionForResponseTest(responseContent);
        httpServerConnection.writeFailureResponse(400, "failureMessage", null);
    }

    @Test
    public void writeFailureResponseWithEmptyParams() throws Exception {
        ByteArrayOutputStream responseContent = new ByteArrayOutputStream();
        HttpServerConnection httpServerConnection = this.createHttpServerConnectionForResponseTest(responseContent);
        httpServerConnection.writeFailureResponse(500, "failureMessage", new HashMap());
        String response = new String(responseContent.toByteArray());
        Assert.assertThat((Object)response.startsWith("HTTP/1.1 500"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)response.contains("Connection: close"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)response.endsWith("failureMessage"), (Matcher)Is.is((Object)true));
    }

    @Test
    public void writeFailureResponseWithParams() throws Exception {
        ByteArrayOutputStream responseContent = new ByteArrayOutputStream();
        HttpServerConnection httpServerConnection = this.createHttpServerConnectionForResponseTest(responseContent);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("header1", "value1");
        headers.put("header2", "value2");
        httpServerConnection.writeFailureResponse(429, "failureMessage", headers);
        String response = new String(responseContent.toByteArray());
        Assert.assertThat((Object)response.startsWith("HTTP/1.1 429"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)response.contains("header1: value1"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)response.contains("header2: value2"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)response.endsWith("failureMessage"), (Matcher)Is.is((Object)true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createHttpServerConnectionWithHttpConnectorProperties() throws Exception {
        HttpConnector httpConnector = new HttpConnector(muleContext);
        httpConnector.setSendTcpNoDelay(false);
        httpConnector.setKeepAlive(true);
        httpConnector.setReceiveBufferSize(1024);
        httpConnector.setServerSoTimeout(5000);
        httpConnector.initialise();
        ServerSocket serverSocket = null;
        Socket clientServerSocket = null;
        Socket serverClientSocket = null;
        try {
            serverSocket = httpConnector.getServerSocketFactory().createServerSocket(this.port1.getNumber(), -1, Boolean.valueOf(true));
            clientServerSocket = new Socket("localhost", this.port1.getNumber());
            serverClientSocket = serverSocket.accept();
            HttpServerConnection conn = new HttpServerConnection(serverClientSocket, muleContext.getConfiguration().getDefaultEncoding(), httpConnector);
            Assert.assertEquals((Object)false, (Object)conn.isSocketTcpNoDelay());
            Assert.assertEquals((Object)true, (Object)conn.isSocketKeepAlive());
            Assert.assertEquals((long)1024L, (long)conn.getSocketReceiveBufferSize());
            Assert.assertEquals((long)5000L, (long)conn.getSocketTimeout());
        }
        finally {
            if (clientServerSocket != null) {
                clientServerSocket.close();
            }
            if (serverClientSocket != null) {
                serverClientSocket.close();
            }
            if (serverSocket != null) {
                serverSocket.close();
            }
        }
    }

    @Test
    public void resetClosesRequestBody() throws Exception {
        this.configureValidRequestForSocketInputStream();
        HttpServerConnection httpServerConnection = new HttpServerConnection(this.mockSocket, muleContext.getConfiguration().getDefaultEncoding(), this.mockHttpConnector){

            protected HttpRequest createHttpRequest() throws IOException {
                return HttpServerConnectionTestCase.this.mockHttpRequest;
            }
        };
        httpServerConnection.readRequest();
        httpServerConnection.reset();
        ((InputStream)Mockito.verify((Object)this.mockHttpRequest.getBody(), (VerificationMode)Mockito.times((int)1))).close();
    }

    private HttpServerConnection createHttpServerConnectionForResponseTest(ByteArrayOutputStream responseContent) throws IOException {
        this.configureValidRequestForSocketInputStream();
        Mockito.when((Object)this.mockSocket.getOutputStream()).thenReturn((Object)responseContent);
        return new HttpServerConnection(this.mockSocket, muleContext.getConfiguration().getDefaultEncoding(), this.mockHttpConnector);
    }

    private void testUrlWithoutParams(String requestUrl, String expectedUrlWithoutParams) throws IOException {
        Mockito.when((Object)this.mockSocket.getInputStream()).thenReturn((Object)new ByteArrayInputStream(String.format("GET %s HTTP/1.0\n", requestUrl).getBytes()));
        HttpServerConnection httpServerConnection = new HttpServerConnection(this.mockSocket, muleContext.getConfiguration().getDefaultEncoding(), this.mockHttpConnector);
        String urlWithoutParams = httpServerConnection.getUrlWithoutRequestParams();
        Assert.assertThat((Object)urlWithoutParams, (Matcher)Is.is((Object)expectedUrlWithoutParams));
    }
}

