/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http;

import org.junit.Assert;
import org.junit.Test;
import org.mule.transport.http.AbstractNamespaceHandlerTestCase;
import org.mule.transport.http.HttpConnector;
import org.mule.transport.http.HttpsConnector;
import org.mule.transport.http.HttpsPollingConnector;

public class HttpsNamespaceHandlerTestCase
extends AbstractNamespaceHandlerTestCase {
    public HttpsNamespaceHandlerTestCase() {
        super("https");
    }

    @Test
    public void testConnectorProperties() {
        HttpsConnector connector = (HttpsConnector)muleContext.getRegistry().lookupConnector("httpsConnector");
        this.testBasicProperties((HttpConnector)connector);
        Assert.assertTrue((boolean)connector.getKeyStore().endsWith("/serverKeystore"));
        Assert.assertEquals((Object)"muleserver", (Object)connector.getKeyAlias());
        Assert.assertEquals((Object)"mulepassword", (Object)connector.getKeyPassword());
        Assert.assertEquals((Object)"mulepassword", (Object)connector.getKeyStorePassword());
        Assert.assertTrue((boolean)connector.getClientKeyStore().endsWith("/clientKeystore"));
        Assert.assertEquals((Object)"mulepassword", (Object)connector.getClientKeyStorePassword());
        Assert.assertTrue((boolean)connector.getTrustStore().endsWith("/trustStore"));
        Assert.assertEquals((Object)"mulepassword", (Object)connector.getTrustStorePassword());
        Assert.assertTrue((boolean)connector.isExplicitTrustStoreOnly());
        Assert.assertTrue((boolean)connector.isRequireClientAuthentication());
    }

    @Test
    public void testPollingProperties() {
        HttpsPollingConnector connector = (HttpsPollingConnector)muleContext.getRegistry().lookupConnector("polling");
        Assert.assertNotNull((Object)connector);
        Assert.assertEquals((long)3456L, (long)connector.getPollingFrequency());
        Assert.assertFalse((boolean)connector.isCheckEtag());
        Assert.assertFalse((boolean)connector.isDiscardEmptyContent());
    }
}

