/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.components;

import java.text.MessageFormat;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.component.Component;
import org.mule.construct.Flow;
import org.mule.routing.filters.WildcardFilter;
import org.mule.routing.filters.logic.NotFilter;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.transport.http.components.RestServiceWrapper;

public class RestServiceComponentFlowTestCase
extends FunctionalTestCase {
    public static final String FLOW_NAME = "WORMS";
    public static final String FLOW_URL = MessageFormat.format("{0}header:serviceUrl{1}", "#[", "]");

    protected String getConfigFile() {
        return "rest-service-component-test-flow.xml";
    }

    @Test
    public void testResetServiceNamespaceHandler() throws Exception {
        Flow f = (Flow)muleContext.getRegistry().lookupFlowConstruct(FLOW_NAME);
        Component component = (Component)f.getMessageProcessors().get(0);
        Assert.assertTrue((boolean)(component instanceof RestServiceWrapper));
        RestServiceWrapper restServiceWrapper = (RestServiceWrapper)component;
        Assert.assertEquals((Object)restServiceWrapper.getServiceUrl(), (Object)FLOW_URL);
        Assert.assertEquals((Object)restServiceWrapper.getHttpMethod(), (Object)"POST");
        Assert.assertNotNull((Object)restServiceWrapper.getFilter());
        Assert.assertEquals(NotFilter.class, restServiceWrapper.getFilter().getClass());
        NotFilter filter = (NotFilter)restServiceWrapper.getFilter();
        Assert.assertEquals(filter.getFilter().getClass(), WildcardFilter.class);
        WildcardFilter innerFilter = (WildcardFilter)filter.getFilter();
        Assert.assertEquals((Object)innerFilter.getPattern(), (Object)"*xyz*");
        Assert.assertNotNull((Object)restServiceWrapper.getPayloadParameterNames());
        Assert.assertEquals((long)restServiceWrapper.getPayloadParameterNames().size(), (long)2L);
        Assert.assertEquals(restServiceWrapper.getPayloadParameterNames().get(0), (Object)"test-property1");
        Assert.assertEquals(restServiceWrapper.getPayloadParameterNames().get(1), (Object)"test-property2");
        Assert.assertNotNull((Object)restServiceWrapper.getRequiredParams());
        Assert.assertEquals((long)restServiceWrapper.getRequiredParams().size(), (long)2L);
        Assert.assertEquals(restServiceWrapper.getRequiredParams().get("r1"), (Object)"rv1");
        Assert.assertEquals(restServiceWrapper.getRequiredParams().get("r2"), (Object)"rv2");
        Assert.assertNotNull((Object)restServiceWrapper.getOptionalParams());
        Assert.assertEquals((long)restServiceWrapper.getOptionalParams().size(), (long)2L);
        Assert.assertEquals(restServiceWrapper.getOptionalParams().get("o1"), (Object)"ov1");
        Assert.assertEquals(restServiceWrapper.getOptionalParams().get("o2"), (Object)"ov2");
    }
}

