/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.functional;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.lang.time.StopWatch;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class HttpContinueFunctionalTestCase
extends AbstractServiceAndFlowTestCase {
    private static final int DEFAULT_HTTP_CLIENT_CONTINUE_WAIT = 3000;
    protected StopWatch stopWatch;
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");

    public HttpContinueFunctionalTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "http-functional-test-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "http-functional-test-flow.xml"});
    }

    @Test
    public void testSendWithContinue() throws Exception {
        this.stopWatch = new StopWatch();
        LocalMuleClient client = muleContext.getClient();
        HttpClientParams params = new HttpClientParams();
        params.setVersion(HttpVersion.HTTP_1_1);
        params.setBooleanParameter("http.protocol.expect-continue", true);
        HashMap<String, HttpClientParams> props = new HashMap<String, HttpClientParams>();
        props.put("http.params", params);
        this.stopWatch.start();
        MuleMessage result = client.send("clientEndpoint", (Object)"Test Message", props);
        this.stopWatch.stop();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"Test Message Received", (Object)result.getPayloadAsString());
        if (this.stopWatch.getTime() > 3000L) {
            Assert.fail((String)"Server did not handle Expect=100-continue header properly,");
        }
    }
}

