/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.functional;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.httpclient.Header;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.transport.http.HttpRequest;
import org.mule.transport.http.functional.AbstractMockHttpServerTestCase;
import org.mule.transport.http.functional.MockHttpServer;
import org.mule.transport.http.functional.SingleRequestMockHttpServer;

public class HttpCookieTestCase
extends AbstractMockHttpServerTestCase {
    private CountDownLatch latch = new CountDownLatch(1);
    private boolean cookieFound = false;
    private List<String> cookieHeaders = new ArrayList<String>();
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");

    public HttpCookieTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "http-cookie-test-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "http-cookie-test-flow.xml"});
    }

    @Override
    protected MockHttpServer getHttpServer() {
        return new SimpleHttpServer(this.dynamicPort.getNumber());
    }

    @Test
    public void testCookies() throws Exception {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("COOKIE_HEADER", "MYCOOKIE");
        LocalMuleClient client = muleContext.getClient();
        client.dispatch("vm://vm-in", (Object)"foobar", properties);
        Assert.assertTrue((boolean)this.latch.await(5000L, TimeUnit.MILLISECONDS));
        Assert.assertTrue((boolean)this.cookieFound);
        Assert.assertEquals((long)2L, (long)this.cookieHeaders.size());
        this.assertThereIsCookieWithThisContent("$Version=0; customCookie=yes", this.cookieHeaders);
        this.assertThereIsCookieWithThisContent("$Version=0; expressionCookie=MYCOOKIE", this.cookieHeaders);
    }

    private void assertThereIsCookieWithThisContent(String content, List<String> listOfRawCookies) {
        for (String rawCookie : listOfRawCookies) {
            if (rawCookie == null || !rawCookie.contains(content)) continue;
            return;
        }
        Assert.fail((String)("There should be a cookie with content '" + content + "': " + listOfRawCookies));
    }

    private class SimpleHttpServer
    extends SingleRequestMockHttpServer {
        public SimpleHttpServer(int listenPort) {
            super(listenPort, muleContext.getConfiguration().getDefaultEncoding());
        }

        @Override
        protected void processSingleRequest(HttpRequest httpRequest) throws Exception {
            for (Header header : httpRequest.getHeaders()) {
                if (!header.getName().equals("Cookie")) continue;
                HttpCookieTestCase.this.cookieFound = true;
                HttpCookieTestCase.this.cookieHeaders.add(header.getValue());
            }
            HttpCookieTestCase.this.latch.countDown();
        }
    }
}

