/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.functional;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleEventContext;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.functional.EventCallback;
import org.mule.tck.functional.FunctionalTestComponent;
import org.mule.tck.junit4.rule.DynamicPort;

public class HttpFunctionalTestCase
extends AbstractServiceAndFlowTestCase {
    protected static String TEST_MESSAGE = "Test Http Request (R\u00ef\u00bf\u00bddgr\u00ef\u00bf\u00bdd), 57 = \u06f7\u06f5 in Arabic";
    protected boolean checkPathProperties = true;
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");

    public HttpFunctionalTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList(new Object[0][]);
    }

    @Test
    public void testSend() throws Exception {
        FunctionalTestComponent testComponent = this.getFunctionalTestComponent("testComponent");
        Assert.assertNotNull((Object)testComponent);
        if (this.checkPathProperties) {
            EventCallback callback = new EventCallback(){

                public void eventReceived(MuleEventContext context, Object component) throws Exception {
                    MuleMessage msg = context.getMessage();
                    Assert.assertEquals((Object)"/", (Object)msg.getInboundProperty("http.request"));
                    Assert.assertEquals((Object)"/", (Object)msg.getInboundProperty("http.request.path"));
                    Assert.assertEquals((Object)"/", (Object)msg.getInboundProperty("http.context.path"));
                }
            };
            testComponent.setEventCallback(callback);
        }
        LocalMuleClient client = muleContext.getClient();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("Content-Type", "text/plain;charset=UTF-8");
        MuleMessage result = client.send("clientEndpoint", (Object)TEST_MESSAGE, props);
        Assert.assertEquals((Object)(TEST_MESSAGE + " Received"), (Object)result.getPayloadAsString());
    }
}

