/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.functional;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.expression.RequiredValueException;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class HttpFunctionalWithQueryTestCase
extends AbstractServiceAndFlowTestCase {
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");

    public HttpFunctionalWithQueryTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "http-functional-test-with-query-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "http-functional-test-with-query-flow.xml"});
    }

    @Test
    public void testSend() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage result = client.send("clientEndpoint1", null, null);
        Assert.assertEquals((Object)"boobar", (Object)result.getPayloadAsString());
    }

    @Test
    public void testSendWithParams() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("foo", "noo");
        props.put("far", "nar");
        MuleMessage result = client.send("clientEndpoint2", null, props);
        Assert.assertEquals((Object)"noonar", (Object)result.getPayloadAsString());
    }

    @Test
    public void testSendWithBadParams() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("hoo", "noo");
        props.put("har", "nar");
        try {
            client.send("clientEndpoint2", null, props);
            Assert.fail((String)"Required values missing");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof RequiredValueException));
        }
    }
}

