/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.functional;

import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.lang.StringUtils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class HttpKeepAliveFunctionalTestCase
extends AbstractServiceAndFlowTestCase {
    private static final String IN_CONNECTOR_NO_KEEP_ALIVE_EP_NO_KEEP_ALIVE = "inConnectorNoKeepAliveEpNoKeepAlive";
    private static final String IN_CONNECTOR_KEEP_ALIVE_EP_KEEP_ALIVE = "inConnectorKeepAliveEpKeepAlive";
    private static final String IN_CONNECTOR_NO_KEEP_ALIVE_EP_KEEP_ALIVE = "inConnectorNoKeepAliveEpKeepAlive";
    private static final String IN_CONNECTOR_KEEP_ALIVE_EP_NO_KEEP_ALIVE = "inConnectorKeepAliveEpNoKeepAlive";
    private static final String IN_CONNECTOR_NO_KEEP_ALIVE_EP_EMPTY = "inConnectorNoKeepAliveEpEmpty";
    private static final String IN_CONNECTOR_KEEP_ALIVE_EP_EMPTY = "inConnectorKeepAliveEpEmpty";
    private static final String CLOSE = "close";
    private static final String KEEP_ALIVE = "Keep-Alive";
    private static final String EMPTY = "";
    @Rule
    public DynamicPort dynamicPort1 = new DynamicPort("port1");
    @Rule
    public DynamicPort dynamicPort2 = new DynamicPort("port2");
    @Rule
    public DynamicPort dynamicPort3 = new DynamicPort("port3");
    @Rule
    public DynamicPort dynamicPort4 = new DynamicPort("port4");
    @Rule
    public DynamicPort dynamicPort5 = new DynamicPort("port5");
    @Rule
    public DynamicPort dynamicPort6 = new DynamicPort("port6");

    public HttpKeepAliveFunctionalTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "http-keep-alive-config-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "http-keep-alive-config-flow.xml"});
    }

    @Test
    public void testHttp10ConnectorKeepAliveEpEmpty() throws Exception {
        this.doTestKeepAliveInHttp10(this.getEndpointAddress(IN_CONNECTOR_KEEP_ALIVE_EP_EMPTY));
    }

    @Test
    public void testHttp10ConnectorNoKeepAliveEpEmpty() throws Exception {
        this.doTestNoKeepAliveInHttp10(this.getEndpointAddress(IN_CONNECTOR_NO_KEEP_ALIVE_EP_EMPTY));
    }

    @Test
    public void testHttp10ConnectorKeepAliveEpNoKeepAlive() throws Exception {
        this.doTestNoKeepAliveInHttp10(this.getEndpointAddress(IN_CONNECTOR_KEEP_ALIVE_EP_NO_KEEP_ALIVE));
    }

    @Test
    public void testHttp10ConnectorNoKeepAliveEpKeepAlive() throws Exception {
        this.doTestKeepAliveInHttp10(this.getEndpointAddress(IN_CONNECTOR_NO_KEEP_ALIVE_EP_KEEP_ALIVE));
    }

    @Test
    public void testHttp10ConnectorKeepAliveEpKeepAlive() throws Exception {
        this.doTestKeepAliveInHttp10(this.getEndpointAddress(IN_CONNECTOR_KEEP_ALIVE_EP_KEEP_ALIVE));
    }

    @Test
    public void testHttp10ConnectorNoKeepAliveEpNoKeepAlive() throws Exception {
        this.doTestNoKeepAliveInHttp10(this.getEndpointAddress(IN_CONNECTOR_NO_KEEP_ALIVE_EP_NO_KEEP_ALIVE));
    }

    @Test
    public void testHttp11ConnectorKeepAliveEpEmpty() throws Exception {
        this.doTestKeepAliveInHttp11(this.getEndpointAddress(IN_CONNECTOR_KEEP_ALIVE_EP_EMPTY));
    }

    @Test
    public void testHttp11ConnectorNoKeepAliveEpEmpty() throws Exception {
        this.doTestNoKeepAliveInHttp11(this.getEndpointAddress(IN_CONNECTOR_NO_KEEP_ALIVE_EP_EMPTY));
    }

    @Test
    public void testHttp11ConnectorKeepAliveEpNoKeepAlive() throws Exception {
        this.doTestNoKeepAliveInHttp11(this.getEndpointAddress(IN_CONNECTOR_KEEP_ALIVE_EP_NO_KEEP_ALIVE));
    }

    @Test
    public void testHttp11ConnectorNoKeepAliveEpKeepAlive() throws Exception {
        this.doTestKeepAliveInHttp11(this.getEndpointAddress(IN_CONNECTOR_NO_KEEP_ALIVE_EP_KEEP_ALIVE));
    }

    @Test
    public void testHttp11ConnectorKeepAliveEpKeepAlive() throws Exception {
        this.doTestKeepAliveInHttp11(this.getEndpointAddress(IN_CONNECTOR_KEEP_ALIVE_EP_KEEP_ALIVE));
    }

    @Test
    public void testHttp11ConnectorNoKeepAliveEpNoKeepAlive() throws Exception {
        this.doTestNoKeepAliveInHttp11(this.getEndpointAddress(IN_CONNECTOR_NO_KEEP_ALIVE_EP_NO_KEEP_ALIVE));
    }

    private void doTestKeepAliveInHttp10(String endpointAddress) throws Exception {
        HttpClient httpClient = this.setupHttpClient(HttpVersion.HTTP_1_0);
        this.doTestHttp(endpointAddress, EMPTY, CLOSE, httpClient);
        this.doTestHttp(endpointAddress, CLOSE, CLOSE, httpClient);
        this.doTestHttp(endpointAddress, KEEP_ALIVE, KEEP_ALIVE, httpClient);
    }

    private void doTestNoKeepAliveInHttp10(String endpointAddress) throws Exception {
        HttpClient httpClient = this.setupHttpClient(HttpVersion.HTTP_1_0);
        this.doTestHttp(endpointAddress, EMPTY, CLOSE, httpClient);
        this.doTestHttp(endpointAddress, CLOSE, CLOSE, httpClient);
        this.doTestHttp(endpointAddress, KEEP_ALIVE, CLOSE, httpClient);
    }

    private void doTestKeepAliveInHttp11(String endpointAddress) throws Exception {
        HttpClient httpClient = this.setupHttpClient(HttpVersion.HTTP_1_1);
        this.doTestHttp(endpointAddress, EMPTY, EMPTY, httpClient);
        this.doTestHttp(endpointAddress, CLOSE, CLOSE, httpClient);
        this.doTestHttp(endpointAddress, KEEP_ALIVE, EMPTY, httpClient);
    }

    private void doTestNoKeepAliveInHttp11(String endpointAddress) throws Exception {
        HttpClient httpClient = this.setupHttpClient(HttpVersion.HTTP_1_1);
        this.doTestHttp(endpointAddress, EMPTY, CLOSE, httpClient);
        this.doTestHttp(endpointAddress, CLOSE, CLOSE, httpClient);
        this.doTestHttp(endpointAddress, KEEP_ALIVE, CLOSE, httpClient);
    }

    private HttpClient setupHttpClient(HttpVersion version) {
        HttpClientParams params = new HttpClientParams();
        params.setVersion(version);
        return new HttpClient(params);
    }

    private void doTestHttp(String url, String inConnectionHeaderValue, String expectedConnectionHeaderValue, HttpClient httpClient) throws Exception {
        GetMethod request = new GetMethod(url);
        if (StringUtils.isEmpty((String)inConnectionHeaderValue)) {
            request.removeRequestHeader("Connection");
        } else {
            request.setRequestHeader("Connection", inConnectionHeaderValue);
        }
        this.runHttpMethodAndAssertConnectionHeader((HttpMethod)request, expectedConnectionHeaderValue, httpClient);
        request = new GetMethod(url);
        request.setRequestHeader("Connection", CLOSE);
        int status = httpClient.executeMethod((HttpMethod)request);
        Assert.assertEquals((long)200L, (long)status);
    }

    private void runHttpMethodAndAssertConnectionHeader(HttpMethod request, String expectedConnectionHeaderValue, HttpClient httpClient) throws Exception {
        String connectionHeader;
        int status = httpClient.executeMethod(request);
        Assert.assertEquals((long)200L, (long)status);
        if (httpClient.getParams().getVersion().equals(HttpVersion.HTTP_1_0)) {
            connectionHeader = request.getResponseHeader("Connection").getValue();
            junit.framework.Assert.assertNotNull((Object)connectionHeader);
        } else {
            Header responseHeader = request.getResponseHeader("Connection");
            connectionHeader = responseHeader != null ? responseHeader.getValue() : EMPTY;
        }
        Assert.assertEquals((Object)expectedConnectionHeaderValue, (Object)connectionHeader);
    }

    private InboundEndpoint getEndpoint(String endpointName) {
        return (InboundEndpoint)muleContext.getRegistry().lookupObject(endpointName);
    }

    private String getEndpointAddress(String endpointName) {
        return this.getEndpoint(endpointName).getAddress();
    }
}

