/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.functional;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.bio.SocketConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class HttpMultipleCookiesTestCase
extends AbstractServiceAndFlowTestCase {
    protected static String TEST_MESSAGE = "Test Http Request ";
    protected static final Log logger = LogFactory.getLog(HttpMultipleCookiesTestCase.class);
    private CountDownLatch simpleServerLatch = new CountDownLatch(1);
    private CountDownLatch simpleServerShutdownLatch = new CountDownLatch(1);
    private static AtomicBoolean cookiesRecieved = new AtomicBoolean(false);
    private Server server = null;
    @Rule
    public DynamicPort dynamicPort1 = new DynamicPort("port1");
    @Rule
    public DynamicPort dynamicPort2 = new DynamicPort("port2");

    public HttpMultipleCookiesTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
        this.setStartContext(false);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "http-multiple-cookies-test-flow.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "http-multiple-cookies-test-service.xml"});
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.startServer();
        Assert.assertTrue((boolean)this.simpleServerLatch.await(5000L, TimeUnit.MILLISECONDS));
    }

    protected void doTearDown() throws Exception {
        super.doTearDown();
        muleContext.stop();
        this.stopServer();
        Assert.assertTrue((boolean)this.simpleServerShutdownLatch.await(5000L, TimeUnit.MILLISECONDS));
    }

    @Test
    public void testSendDirectly() throws Exception {
        muleContext.start();
        this.sendMessage(this.dynamicPort2.getNumber());
    }

    @Test
    public void testSendviaMule() throws Exception {
        muleContext.start();
        this.sendMessage(this.dynamicPort1.getNumber());
    }

    protected void sendMessage(int port) throws Exception {
        HttpClient client2 = new HttpClient();
        client2.getParams().setCookiePolicy("rfc2109");
        HttpState state = new HttpState();
        Cookie cookie1 = new Cookie("localhost", "TheFirst", "First", "/", null, false);
        state.addCookie(cookie1);
        Cookie cookie2 = new Cookie("localhost", "TheSecond", "Value2", "/", null, false);
        state.addCookie(cookie2);
        Cookie cookie3 = new Cookie("localhost", "TheThird", "Value3", "/", null, false);
        state.addCookie(cookie3);
        client2.setState(state);
        PostMethod method = new PostMethod("http://localhost:" + port);
        Thread.sleep(5000L);
        client2.executeMethod((HttpMethod)method);
        Assert.assertEquals((Object)TEST_MESSAGE, (Object)method.getResponseBodyAsString());
        Assert.assertTrue((String)"Cookies were not recieved", (boolean)cookiesRecieved.get());
        for (Cookie cookie : client2.getState().getCookies()) {
            logger.debug((Object)(cookie.getName() + " " + cookie.getValue()));
        }
        Assert.assertEquals((long)6L, (long)client2.getState().getCookies().length);
    }

    protected void startServer() throws Exception {
        logger.debug((Object)"server starting");
        Server server = new Server();
        SocketConnector connector = new SocketConnector();
        connector.setPort(this.dynamicPort2.getNumber());
        server.setConnectors(new Connector[]{connector});
        ServletContextHandler handler = new ServletContextHandler();
        server.setHandler((Handler)handler);
        handler.setContextPath("/");
        handler.addServlet(new ServletHolder(HelloServlet.class), "/");
        server.start();
        this.simpleServerLatch.countDown();
        logger.debug((Object)"Server started");
    }

    protected void stopServer() throws Exception {
        logger.debug((Object)"server stopping");
        if (this.server != null && this.server.isRunning()) {
            Assert.assertEquals((Object)1, (Object)this.server.getConnectors());
            this.server.getConnectors()[0].stop();
        }
        this.simpleServerShutdownLatch.countDown();
        logger.debug((Object)"Server stopped");
    }

    public static class HelloServlet
    extends HttpServlet {
        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            try {
                response.setContentType("text/xml");
                response.setContentLength(TEST_MESSAGE.length());
                for (int i = 0; i < 3; ++i) {
                    javax.servlet.http.Cookie cookie1 = new javax.servlet.http.Cookie("OutputCookieName" + i, "OutputCookieValue" + i);
                    response.addCookie(cookie1);
                }
                cookiesRecieved.set(false);
                javax.servlet.http.Cookie[] cookies = request.getCookies();
                if (cookies != null) {
                    for (javax.servlet.http.Cookie cookie : cookies) {
                        logger.debug((Object)(cookie.getName() + " " + cookie.getValue()));
                        cookiesRecieved.set(true);
                    }
                }
                response.setStatus(200);
                response.getWriter().println(TEST_MESSAGE);
            }
            catch (Exception e) {
                logger.error((Object)"Servlet error", (Throwable)e);
                throw new ServletException((Throwable)e);
            }
        }

        protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            this.doGet(request, response);
        }
    }
}

