/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.functional;

import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.transport.http.HttpRequest;
import org.mule.transport.http.functional.AbstractMockHttpServerTestCase;
import org.mule.transport.http.functional.MockHttpServer;
import org.mule.transport.http.functional.SingleRequestMockHttpServer;
import org.mule.util.concurrent.Latch;

public class HttpOutboundTestCase
extends AbstractMockHttpServerTestCase {
    @ClassRule
    public static DynamicPort dynamicPort = new DynamicPort("port1");
    private Latch testLatch = new Latch();
    private String httpMethod;
    private String body;

    public HttpOutboundTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
        this.setDisposeContextPerClass(true);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "http-outbound-config-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "http-outbound-config-flow.xml"});
    }

    @Override
    protected MockHttpServer getHttpServer() {
        return new SimpleHttpServer(dynamicPort.getNumber());
    }

    @Test
    public void testOutboundDelete() throws Exception {
        this.sendHttpRequest("vm://doDelete", "DELETE");
        this.assertEmptyRequestBody();
    }

    @Test
    public void testOutboundGet() throws Exception {
        this.sendHttpRequest("vm://doGet", "GET");
        this.assertEmptyRequestBody();
    }

    @Test
    public void testOutboundHead() throws Exception {
        this.sendHttpRequest("vm://doHead", "HEAD");
        this.assertEmptyRequestBody();
    }

    @Test
    public void testOutboundOptions() throws Exception {
        this.sendHttpRequest("vm://doOptions", "OPTIONS");
        this.assertEmptyRequestBody();
    }

    @Test
    public void testOutboundPost() throws Exception {
        this.sendHttpRequest("vm://doPost", "POST");
        this.assertPayloadInRequestBody();
    }

    @Test
    public void testOutboundPut() throws Exception {
        this.sendHttpRequest("vm://doPut", "PUT");
        this.assertPayloadInRequestBody();
    }

    @Test
    public void testOutboundTrace() throws Exception {
        this.sendHttpRequest("vm://doTrace", "TRACE");
        this.assertEmptyRequestBody();
    }

    @Test
    public void testOutboundPatch() throws Exception {
        this.sendHttpRequest("vm://doPatch", "PATCH");
        this.assertPayloadInRequestBody();
    }

    private void sendHttpRequest(String endpoint, String expectedHttpMethod) throws Exception {
        muleContext.getClient().dispatch(endpoint, (Object)"Test Message", null);
        Assert.assertTrue((boolean)this.testLatch.await(5000L, TimeUnit.MILLISECONDS));
        Assert.assertEquals((Object)expectedHttpMethod, (Object)this.httpMethod);
    }

    private void assertPayloadInRequestBody() {
        Assert.assertEquals((Object)"Test Message", (Object)this.body);
    }

    private void assertEmptyRequestBody() {
        Assert.assertNull((Object)this.body);
    }

    private class SimpleHttpServer
    extends SingleRequestMockHttpServer {
        public SimpleHttpServer(int listenPort) {
            super(listenPort, muleContext.getConfiguration().getDefaultEncoding());
        }

        @Override
        protected void processSingleRequest(HttpRequest httpRequest) throws Exception {
            HttpOutboundTestCase.this.httpMethod = httpRequest.getRequestLine().getMethod();
            HttpOutboundTestCase.this.body = httpRequest.getBodyString();
            HttpOutboundTestCase.this.testLatch.countDown();
        }
    }
}

