/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.functional;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.transport.http.HttpRequest;
import org.mule.transport.http.functional.AbstractMockHttpServerTestCase;
import org.mule.transport.http.functional.MockHttpServer;
import org.mule.transport.http.functional.SingleRequestMockHttpServer;
import org.mule.util.concurrent.Latch;

public class HttpOutboundThrowExceptionTestCase
extends AbstractMockHttpServerTestCase {
    @ClassRule
    public static DynamicPort inboundPort = new DynamicPort("portIn");
    @ClassRule
    public static DynamicPort outboundPort = new DynamicPort("portOut");
    private Latch testLatch = new Latch();

    public HttpOutboundThrowExceptionTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
        this.setDisposeContextPerClass(true);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList(new Object[][]{{AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "http-outbound-throw-exception-config.xml"}});
    }

    @Override
    protected MockHttpServer getHttpServer() {
        return new SimpleHttpServer(outboundPort.getNumber());
    }

    @Test
    public void errorStatusPropagation() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("Content-Type", "text/plain;charset=UTF-8");
        MuleMessage result = client.send("errorPropagationEndpoint", (Object)"Test Message", props);
        Assert.assertThat((Object)((String)result.getInboundProperty("http.status")), (Matcher)CoreMatchers.is((Object)"400"));
    }

    @Test
    public void errorStatusThrowException() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("Content-Type", "text/plain;charset=UTF-8");
        MuleMessage result = client.send("exceptionOnErrorStatusEndpoint", (Object)"Test Message", props);
        Assert.assertThat((Object)((String)result.getInboundProperty("http.status")), (Matcher)CoreMatchers.is((Object)"500"));
    }

    private class SimpleHttpServer
    extends SingleRequestMockHttpServer {
        private static final String HTTP_STATUS_LINE_BAD_REQUEST = "HTTP/1.1 400 Bad Request\n";

        public SimpleHttpServer(int listenPort) {
            super(listenPort, muleContext.getConfiguration().getDefaultEncoding(), HTTP_STATUS_LINE_BAD_REQUEST);
        }

        @Override
        protected void processSingleRequest(HttpRequest httpRequest) throws Exception {
            HttpOutboundThrowExceptionTestCase.this.testLatch.countDown();
        }
    }
}

