/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.functional;

import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.context.notification.ServerNotification;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.functional.FunctionalTestNotificationListener;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.util.concurrent.Latch;

public class HttpPollingWithTransformersFunctionalTestCase
extends AbstractServiceAndFlowTestCase {
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");

    public HttpPollingWithTransformersFunctionalTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "mule-http-polling-with-transformers-config-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "mule-http-polling-with-transformers-config-flow.xml"});
    }

    @Test
    public void testPollingHttpConnector() throws Exception {
        final Latch latch = new Latch();
        final AtomicBoolean transformPropagated = new AtomicBoolean(false);
        muleContext.registerListener((ServerNotificationListener)new FunctionalTestNotificationListener(){

            public void onNotification(ServerNotification notification) {
                latch.countDown();
                if (notification.getSource().toString().endsWith("toClient-only")) {
                    transformPropagated.set(true);
                }
            }
        }, "polledUMO");
        LocalMuleClient client = muleContext.getClient();
        MuleMessage result = client.request("vm://toclient", 50000L);
        Assert.assertNotNull((Object)result.getPayload());
        Assert.assertTrue((String)"Callback called", (boolean)latch.await(1000L, TimeUnit.MILLISECONDS));
        Assert.assertEquals((Object)"/foo toClient-only", (Object)result.getPayloadAsString());
        Assert.assertFalse((boolean)transformPropagated.get());
    }
}

