/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.functional;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.api.MuleEventContext;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.client.MuleClient;
import org.mule.tck.functional.EventCallback;
import org.mule.tck.functional.FunctionalTestComponent;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class HttpStemTestCase
extends FunctionalTestCase {
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");

    protected String getConfigFile() {
        return "http-stem-test.xml";
    }

    @Test
    public void testStemMatching() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        int port = this.dynamicPort.getNumber();
        this.doTest((MuleClient)client, "http://localhost:" + port + "/foo", "/foo", "/foo");
        this.doTest((MuleClient)client, "http://localhost:" + port + "/foo/baz", "/foo", "/foo/baz");
        this.doTest((MuleClient)client, "http://localhost:" + port + "/bar", "/bar", "/bar");
        this.doTest((MuleClient)client, "http://localhost:" + port + "/bar/baz", "/bar", "/bar/baz");
    }

    protected void doTest(MuleClient client, String url, final String contextPath, final String requestPath) throws Exception {
        FunctionalTestComponent testComponent = (FunctionalTestComponent)this.getComponent(contextPath);
        Assert.assertNotNull((Object)testComponent);
        EventCallback callback = new EventCallback(){

            public void eventReceived(MuleEventContext context, Object component) throws Exception {
                MuleMessage msg = context.getMessage();
                Assert.assertEquals((Object)requestPath, (Object)msg.getInboundProperty("http.request"));
                Assert.assertEquals((Object)requestPath, (Object)msg.getInboundProperty("http.request.path"));
                Assert.assertEquals((Object)contextPath, (Object)msg.getInboundProperty("http.context.path"));
            }
        };
        testComponent.setEventCallback(callback);
        MuleMessage result = client.send(url, (Object)"Hello World", null);
        Assert.assertEquals((Object)"Hello World Received", (Object)result.getPayloadAsString());
        int status = (Integer)result.getInboundProperty("http.status", (Object)0);
        Assert.assertEquals((long)200L, (long)status);
    }
}

