/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.functional;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Assert;
import org.junit.runners.Parameterized;
import org.mule.api.MuleEventContext;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.construct.FlowConstruct;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.functional.EventCallback;
import org.mule.tck.functional.FunctionalTestComponent;
import org.mule.transport.http.functional.HttpFunctionalTestCase;

public class HttpsFunctionalTestCase
extends HttpFunctionalTestCase {
    public HttpsFunctionalTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "https-functional-test-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "https-functional-test-flow.xml"});
    }

    @Override
    public void testSend() throws Exception {
        FlowConstruct testSedaService = muleContext.getRegistry().lookupFlowConstruct("testComponent");
        FunctionalTestComponent testComponent = (FunctionalTestComponent)this.getComponent(testSedaService);
        Assert.assertNotNull((Object)testComponent);
        final AtomicBoolean callbackMade = new AtomicBoolean(false);
        EventCallback callback = new EventCallback(){

            public void eventReceived(MuleEventContext context, Object component) throws Exception {
                MuleMessage msg = context.getMessage();
                Assert.assertTrue((boolean)callbackMade.compareAndSet(false, true));
                Assert.assertNotNull((Object)msg.getOutboundProperty("LOCAL_CERTIFICATES"));
            }
        };
        testComponent.setEventCallback(callback);
        LocalMuleClient client = muleContext.getClient();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("Content-Type", "text/plain;charset=UTF-8");
        MuleMessage result = client.send("clientEndpoint", (Object)TEST_MESSAGE, props);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)(TEST_MESSAGE + " Received"), (Object)result.getPayloadAsString());
        Assert.assertTrue((String)"Callback never fired", (boolean)callbackMade.get());
    }
}

