/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.functional;

import java.util.Collections;
import java.util.Map;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class SessionPropertiesTestCase
extends FunctionalTestCase {
    @Rule
    public DynamicPort dynamicPort1 = new DynamicPort("port1");
    @Rule
    public DynamicPort dynamicPort2 = new DynamicPort("port2");
    @Rule
    public DynamicPort dynamicPort3 = new DynamicPort("port3");
    @Rule
    public DynamicPort dynamicPort4 = new DynamicPort("port4");
    @Rule
    public DynamicPort dynamicPort5 = new DynamicPort("port5");
    @Rule
    public DynamicPort dynamicPort6 = new DynamicPort("port6");

    protected String getConfigFile() {
        return "session-properties.xml";
    }

    @Test
    public void testHttp1ToHttp2ToHttp3SessionPropertiesTestCase() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        Map properties = Collections.emptyMap();
        MuleMessage response = client.send("http://localhost:" + this.dynamicPort1.getNumber() + "/Flow1s1", (Object)"some message", properties);
        this.assertNotNullAndNotExceptionResponse(response);
    }

    @Test
    public void testHttp1ToHttp2ThenHttp1ToHttp3SessionPropertiesTestCase() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        Map properties = Collections.emptyMap();
        MuleMessage response = client.send("http://localhost:" + this.dynamicPort4.getNumber() + "/Flow1s2", (Object)"some message", properties);
        this.assertNotNullAndNotExceptionResponse(response);
    }

    private void assertNotNullAndNotExceptionResponse(MuleMessage response) {
        Assert.assertNotNull((Object)response);
        if (response.getExceptionPayload() != null) {
            Assert.fail((String)response.getExceptionPayload().getException().getCause().toString());
        }
    }
}

